/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireCondition {
    private ISapphirePart part;
    private boolean conditionState;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public static SapphireCondition create(ISapphirePart part, Class<?> conditionClass, String conditionParameter) {
        try {
            SapphireCondition condition = (SapphireCondition)conditionClass.newInstance();
            condition.init(part, conditionParameter);
            return condition;
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return null;
        }
    }

    public final void init(ISapphirePart part, String parameter) {
        this.part = part;
        this.initCondition(part, parameter);
        this.updateConditionState();
    }

    protected void initCondition(ISapphirePart part, String parameter) {
    }

    public final ISapphirePart getPart() {
        return this.part;
    }

    protected abstract boolean evaluate();

    public final boolean getConditionState() {
        return this.conditionState;
    }

    protected final void updateConditionState() {
        boolean newConditionState;
        try {
            newConditionState = this.evaluate();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return;
        }
        if (this.conditionState != newConditionState) {
            this.conditionState = newConditionState;
            this.notifyListeners();
        }
    }

    public void dispose() {
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private final void notifyListeners() {
        for (Listener listener : this.listeners) {
            try {
                listener.handleConditionChanged();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    public static abstract class Listener {
        public abstract void handleConditionChanged();
    }
}

