/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.swt.graphics.Image;

public final class SapphireImageCache {
    private final Map<ImageDescriptor, ImageHandle> imageDescToImageHandle = new HashMap<ImageDescriptor, ImageHandle>();
    private final Map<ImageData, ImageDescriptor> imageDataToImageDesc = new HashMap<ImageData, ImageDescriptor>();

    public Image getImage(ImageDescriptor imageDescriptor) {
        return this.getImage(imageDescriptor, Status.Severity.OK);
    }

    public Image getImage(ImageDescriptor imageDescriptor, Status.Severity problemSeverity) {
        ImageHandle imageHandle = this.imageDescToImageHandle.get(imageDescriptor);
        if (imageHandle == null) {
            imageHandle = new ImageHandle(imageDescriptor);
            this.imageDescToImageHandle.put(imageDescriptor, imageHandle);
        }
        return imageHandle.getImage(problemSeverity);
    }

    public ImageDescriptor getImageDescriptor(ModelElementType type) {
        return SwtRendererUtil.toImageDescriptor(type.image());
    }

    public Image getImage(ModelElementType type) {
        return this.getImage(type.image());
    }

    public Image getImage(ImageData imageData) {
        return this.getImage(imageData, Status.Severity.OK);
    }

    public Image getImage(ImageData imageData, Status.Severity severity) {
        if (imageData != null) {
            ImageDescriptor imageDescriptor = this.imageDataToImageDesc.get(imageData);
            if (imageDescriptor == null) {
                imageDescriptor = SwtRendererUtil.toImageDescriptor(imageData);
                this.imageDataToImageDesc.put(imageData, imageDescriptor);
            }
            return this.getImage(imageDescriptor, severity);
        }
        return null;
    }

    public void dispose() {
        for (ImageHandle imageHandle : this.imageDescToImageHandle.values()) {
            imageHandle.dispose();
        }
    }

    private static final class ImageHandle {
        private final ImageDescriptor baseImageDescriptor;
        private Image baseImage;
        private Image warningImage;
        private Image errorImage;

        public ImageHandle(ImageDescriptor baseImageDescriptor) {
            this.baseImageDescriptor = baseImageDescriptor;
        }

        public Image getImage(Status.Severity severity) {
            if (this.baseImageDescriptor == null) {
                return null;
            }
            if (severity == Status.Severity.ERROR) {
                if (this.errorImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, Status.Severity.ERROR);
                    this.errorImage = desc.createImage();
                }
                return this.errorImage;
            }
            if (severity == Status.Severity.WARNING) {
                if (this.warningImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, Status.Severity.WARNING);
                    this.warningImage = desc.createImage();
                }
                return this.warningImage;
            }
            if (this.baseImage == null) {
                this.baseImage = this.baseImageDescriptor.createImage();
            }
            return this.baseImage;
        }

        public void dispose() {
            if (this.baseImage != null) {
                this.baseImage.dispose();
            }
            if (this.errorImage != null) {
                this.errorImage.dispose();
            }
            if (this.warningImage != null) {
                this.warningImage.dispose();
            }
        }
    }
}

