/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;

public abstract class SapphirePropertyEditorActionHandler
extends SapphireActionHandler {
    private ModelPropertyListener listener;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.listener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                SapphirePropertyEditorActionHandler.this.refreshEnablementState();
            }
        };
        this.getModelElement().addListener(this.listener, this.getProperty().getName());
        this.refreshEnablementState();
        this.attach(new Listener(){

            public void handle(Event event) {
                if (event instanceof DisposeEvent) {
                    SapphirePropertyEditorActionHandler.this.getModelElement().removeListener(SapphirePropertyEditorActionHandler.this.listener, SapphirePropertyEditorActionHandler.this.getProperty().getName());
                }
            }
        });
    }

    public final IModelElement getModelElement() {
        return ((SapphirePropertyEditor)this.getPart()).getLocalModelElement();
    }

    public ModelProperty getProperty() {
        return ((SapphirePropertyEditor)this.getPart()).getProperty();
    }

    public final void refreshEnablementState() {
        this.setEnabled(this.computeEnablementState());
    }

    protected boolean computeEnablementState() {
        return this.getModelElement().isPropertyEnabled(this.getProperty());
    }
}

