/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.util.Map;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.SapphirePopup;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PropertyEditorAssistDialog
extends SapphirePopup {
    private final PropertyEditorAssistContext context;
    private final FormToolkit toolkit = new FormToolkit(Display.getDefault());
    private Composite composite;

    public PropertyEditorAssistDialog(Shell shell, Point point, PropertyEditorAssistContext context) {
        super(shell, point);
        this.context = context;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createContentArea(Composite parent) {
        this.composite = (Composite)super.createContentArea(parent);
        ScrolledForm form = this.toolkit.createScrolledForm(this.composite);
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.topMargin = 5;
        layout.bottomMargin = 0;
        layout.verticalSpacing = 10;
        form.getBody().setLayout((Layout)layout);
        for (PropertyEditorAssistSection secdef : this.context.getSections().values()) {
            if (secdef.getContributions().isEmpty()) continue;
            Section section = this.toolkit.createSection(form.getBody(), 64);
            this.toolkit.createCompositeSeparator((Composite)section);
            section.clientVerticalSpacing = 9;
            section.setText(secdef.getLabel());
            TableWrapData td = new TableWrapData();
            td.align = 128;
            td.grabHorizontal = true;
            section.setLayoutData((Object)td);
            Composite composite = this.toolkit.createComposite((Composite)section);
            layout = new TableWrapLayout();
            layout.leftMargin = 0;
            layout.rightMargin = 0;
            layout.topMargin = 0;
            layout.bottomMargin = 0;
            layout.verticalSpacing = 0;
            composite.setLayout((Layout)layout);
            section.setClient((Control)composite);
            for (final PropertyEditorAssistContribution contribution : secdef.getContributions()) {
                SapphireFormText text = new SapphireFormText(composite, 64);
                td = new TableWrapData();
                td.align = 128;
                td.grabHorizontal = true;
                text.setLayoutData(td);
                for (Map.Entry<String, ImageData> image : contribution.images().entrySet()) {
                    text.setImage(image.getKey(), image.getValue());
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<form>");
                buffer.append(contribution.text());
                buffer.append("</form>");
                text.setText(buffer.toString(), true, false);
                text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        try {
                            try {
                                Runnable operation = contribution.link((String)event.getHref());
                                if (operation != null) {
                                    operation.run();
                                }
                            }
                            catch (Exception e) {
                                EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                                if (editFailedException == null) {
                                    SapphireUiFrameworkPlugin.log(e);
                                }
                                PropertyEditorAssistDialog.this.close();
                            }
                        }
                        finally {
                            PropertyEditorAssistDialog.this.close();
                        }
                    }
                });
            }
        }
        parent.pack();
        return this.composite;
    }

    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        this.toolkit.dispose();
        return super.close();
    }

    protected Control getFocusControl() {
        return this.composite;
    }
}

