/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ListUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNodeTemplate
extends SapphirePart {
    private SapphireDiagramEditorPagePart diagramEditor;
    private IDiagramNodeDef definition;
    private IModelElement modelElement;
    private String propertyName;
    private ListProperty modelProperty;
    private JavaType modelElementType;
    private String toolPaletteLabel;
    private String toolPaletteDesc;
    private DiagramEmbeddedConnectionTemplate embeddedConnTemplate;
    private ModelPropertyListener modelPropertyListener;
    private SapphireDiagramPartListener nodePartListener;
    private Set<Listener> listeners;
    private List<DiagramNodePart> diagramNodes;

    @Override
    public void init() {
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.getParentPart();
        this.modelElement = this.getModelElement();
        this.definition = (IDiagramNodeDef)((SapphirePart)this).definition;
        if (this.definition.getToolPaletteLabel().getContent() != null) {
            ValueProperty tpLabelProperty = IDiagramNodeDef.PROP_TOOL_PALETTE_LABEL;
            this.toolPaletteLabel = tpLabelProperty.getLocalizationService().text((String)this.definition.getToolPaletteLabel().getContent(), CapitalizationType.TITLE_STYLE, false);
        }
        this.toolPaletteDesc = (String)this.definition.getToolPaletteDescription().getContent();
        this.diagramNodes = new ArrayList<DiagramNodePart>();
        this.listeners = new CopyOnWriteArraySet<Listener>();
        this.propertyName = (String)this.definition.getProperty().getContent();
        this.modelProperty = (ListProperty)this.resolve(this.modelElement, this.propertyName);
        this.modelElementType = (JavaType)this.definition.getElementType().resolve();
        this.nodePartListener = new SapphireDiagramPartListener(){

            public void handleNodeUpdateEvent(DiagramNodeEvent event) {
                DiagramNodeTemplate.this.notifyNodeUpdate((DiagramNodePart)event.getPart());
            }

            public void handleNodeMoveEvent(DiagramNodeEvent event) {
                DiagramNodeTemplate.this.notifyNodeMoveEvent(event);
            }
        };
        ModelElementList list = this.modelElement.read(this.modelProperty);
        for (IModelElement listEntryModelElement : list) {
            if (this.modelElementType == null) {
                this.createNewNodePart(listEntryModelElement);
                continue;
            }
            Class cl = this.modelElementType.artifact();
            if (cl != null && !cl.isAssignableFrom(listEntryModelElement.getClass())) continue;
            this.createNewNodePart(listEntryModelElement);
        }
        this.modelPropertyListener = new ModelPropertyListener(){

            public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                DiagramNodeTemplate.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    public void initEmbeddedConnections() {
        if (!this.definition.getEmbeddedConnections().isEmpty()) {
            IDiagramExplicitConnectionBindingDef embeddedConnDef = (IDiagramExplicitConnectionBindingDef)this.definition.getEmbeddedConnections().get(0);
            this.embeddedConnTemplate = new DiagramEmbeddedConnectionTemplate(embeddedConnDef);
            IDiagramConnectionDef connDef = this.diagramEditor.getDiagramConnectionDef((String)embeddedConnDef.getConnectionId().getContent());
            this.embeddedConnTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
        }
    }

    @Override
    public IDiagramNodeDef getDefinition() {
        return this.definition;
    }

    public List<DiagramNodePart> getDiagramNodes() {
        return this.diagramNodes;
    }

    public String getToolPaletteLabel() {
        return this.toolPaletteLabel;
    }

    public String getToolPaletteDesc() {
        return this.toolPaletteDesc;
    }

    public IDiagramImageChoice getToolPaletteImage() {
        return (IDiagramImageChoice)this.definition.getToolPaletteImage().element();
    }

    public String getNodeTypeId() {
        return (String)this.definition.getId().getContent();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("Sapphire.Diagram.Node");
        ret.add("Sapphire.Diagram");
        return ret;
    }

    public DiagramNodePart createNewDiagramNode() {
        Class cl;
        IModelElement newElement = null;
        ModelElementList list = this.modelElement.read(this.modelProperty);
        newElement = this.modelElementType == null ? list.addNewElement() : ((cl = this.modelElementType.artifact()) != null ? list.addNewElement(cl) : list.addNewElement());
        DiagramNodePart newNodePart = this.getNodePart(newElement);
        return newNodePart;
    }

    public ModelProperty getModelProperty() {
        return this.modelProperty;
    }

    public ModelElementType getNodeType() {
        if (this.modelElementType == null) {
            return this.modelProperty.getType();
        }
        Class cl = this.modelElementType.artifact();
        return ModelElementType.getModelElementType((Class)cl);
    }

    public DiagramEmbeddedConnectionTemplate getEmbeddedConnectionTemplate() {
        return this.embeddedConnTemplate;
    }

    public void addModelListener() {
        this.modelElement.addListener(this.modelPropertyListener, this.propertyName);
    }

    public void removeModelLister() {
        this.modelElement.removeListener(this.modelPropertyListener, this.propertyName);
    }

    public void addTemplateListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeTemplateListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    private void handleModelPropertyChange(ModelPropertyChangeEvent event) {
        block6: {
            ArrayList<IModelElement> oldList;
            ArrayList<IModelElement> newList;
            block7: {
                IModelElement element = event.getModelElement();
                ModelProperty property = event.getProperty();
                ModelElementList tempList = (ModelElementList)element.read(property);
                newList = new ArrayList<IModelElement>();
                newList = new ArrayList();
                for (IModelElement ele : tempList) {
                    if (this.modelElementType == null) {
                        newList.add(ele);
                        continue;
                    }
                    Class cl = this.modelElementType.artifact();
                    if (cl != null && !cl.isAssignableFrom(ele.getClass())) continue;
                    newList.add(ele);
                }
                if (newList.size() == this.getDiagramNodes().size()) break block6;
                List<DiagramNodePart> nodeParts = this.getDiagramNodes();
                oldList = new ArrayList<IModelElement>(nodeParts.size());
                for (DiagramNodePart nodePart : nodeParts) {
                    oldList.add(nodePart.getLocalModelElement());
                }
                if (newList.size() <= oldList.size()) break block7;
                List<IModelElement> newNodes = ListUtil.ListDiff(newList, oldList);
                for (IModelElement newNode : newNodes) {
                    DiagramNodePart nodePart = this.createNewNodePart(newNode);
                    if (this.diagramEditor.isNodeTemplateVisible(this)) {
                        this.notifyNodeAdd(nodePart);
                    }
                    if (this.embeddedConnTemplate == null) continue;
                    this.embeddedConnTemplate.refreshConnections(newNode);
                }
                break block6;
            }
            if (newList.size() >= oldList.size()) break block6;
            List<IModelElement> deletedNodes = ListUtil.ListDiff(newList, oldList);
            for (IModelElement deletedNode : deletedNodes) {
                DiagramNodePart nodePart = this.getNodePart(deletedNode);
                if (nodePart == null) continue;
                this.notifyNodeDelete(nodePart);
                nodePart.dispose();
                this.diagramNodes.remove(nodePart);
            }
        }
    }

    public DiagramNodePart getNodePart(IModelElement element) {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            if (!nodePart.getLocalModelElement().equals(element)) continue;
            return nodePart;
        }
        return null;
    }

    public DiagramNodePart createNewNodePart(IModelElement element) {
        DiagramNodePart newNode = new DiagramNodePart();
        newNode.init(this, element, this.definition, Collections.<String, String>emptyMap());
        newNode.addListener(this.nodePartListener);
        this.diagramNodes.add(newNode);
        if (this.embeddedConnTemplate != null) {
            this.embeddedConnTemplate.addModelListener(element);
        }
        return newNode;
    }

    public void hideAllNodeParts() {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeDelete(nodePart);
        }
    }

    public void showAllNodeParts() {
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeAdd(nodePart);
        }
        if (this.embeddedConnTemplate != null) {
            this.embeddedConnTemplate.showAllConnectionParts(this);
        }
    }

    @Override
    public void dispose() {
        this.removeModelLister();
        List<DiagramNodePart> nodeParts = this.getDiagramNodes();
        for (DiagramNodePart nodePart : nodeParts) {
            this.notifyNodeDelete(nodePart);
            nodePart.dispose();
        }
        this.diagramNodes.clear();
        if (this.embeddedConnTemplate != null) {
            this.embeddedConnTemplate.dispose();
        }
    }

    public SapphireDiagramEditorPagePart getDiagramEditorPart() {
        return this.diagramEditor;
    }

    private void notifyNodeUpdate(DiagramNodePart nodePart) {
        for (Listener listener : this.listeners) {
            listener.handleNodeUpdate(nodePart);
        }
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        for (Listener listener : this.listeners) {
            listener.handleNodeAdd(nodePart);
        }
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        for (Listener listener : this.listeners) {
            listener.handleNodeDelete(nodePart);
        }
    }

    private void notifyNodeMoveEvent(DiagramNodeEvent event) {
        for (Listener listener : this.listeners) {
            listener.handleNodeMove(event);
        }
    }

    public static abstract class Listener {
        public void handleNodeUpdate(DiagramNodePart nodePart) {
        }

        public void handleNodeAdd(DiagramNodePart nodePart) {
        }

        public void handleNodeDelete(DiagramNodePart nodePart) {
        }

        public void handleNodeMove(DiagramNodeEvent event) {
        }
    }
}

