/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class IdUtil {
    private static final String NODE_ID_SEPARATOR = "#";
    private static final String CONNECTION_ID_SEPARATOR = "&";

    public static String computeNodeId(DiagramNodePart nodePart) {
        StringBuffer buffer = new StringBuffer(nodePart.getNodeTypeId());
        buffer.append(NODE_ID_SEPARATOR);
        String instanceId = nodePart.getInstanceId();
        if (instanceId != null && instanceId.length() > 0) {
            buffer.append(nodePart.getInstanceId());
        } else {
            List<DiagramNodePart> nodeParts = nodePart.getDiagramNodeTemplate().getDiagramNodes();
            int index = nodeParts.indexOf(nodePart);
            buffer.append(index);
        }
        return buffer.toString();
    }

    public static String computeConnectionId(DiagramConnectionPart connPart) {
        StringBuffer buffer = new StringBuffer(connPart.getConnectionTypeId());
        buffer.append(CONNECTION_ID_SEPARATOR);
        String instanceId = connPart.getInstanceId();
        if (instanceId != null && instanceId.length() > 0) {
            buffer.append(connPart.getInstanceId());
        } else {
            IModelElement srcNodeElement = null;
            if (connPart instanceof DiagramEmbeddedConnectionPart) {
                DiagramEmbeddedConnectionPart embeddedConn = (DiagramEmbeddedConnectionPart)connPart;
                srcNodeElement = embeddedConn.getSourceNodePart().getLocalModelElement();
            }
            List<DiagramConnectionPart> connParts = connPart.getDiagramConnectionTemplate().getDiagramConnections(srcNodeElement);
            int index = connParts.indexOf(connPart);
            buffer.append(index);
        }
        return buffer.toString();
    }

    public static DiagramNodePart getNodePart(SapphireDiagramEditorPagePart diagramPart, String nodeId) {
        int nodeIndex;
        int index = nodeId.indexOf(NODE_ID_SEPARATOR);
        if (index == -1) {
            return null;
        }
        String nodePartId = nodeId.substring(0, index);
        String subId = nodeId.substring(index + 1);
        try {
            nodeIndex = Integer.valueOf(subId);
        }
        catch (NumberFormatException numberFormatException) {
            nodeIndex = -1;
        }
        for (DiagramNodeTemplate nodeTemplate : diagramPart.getNodeTemplates()) {
            if (!nodeTemplate.getNodeTypeId().equals(nodePartId)) continue;
            List<DiagramNodePart> nodeParts = nodeTemplate.getDiagramNodes();
            int i = 0;
            while (i < nodeParts.size()) {
                DiagramNodePart nodePart = nodeParts.get(i);
                String nodeId2 = nodePart.getInstanceId();
                if (subId != null && nodeId2 != null && subId.equals(nodeId2)) {
                    return nodePart;
                }
                if (nodeIndex == i) {
                    return nodePart;
                }
                ++i;
            }
        }
        return null;
    }

    public static DiagramConnectionPart getConnectionPart(SapphireDiagramEditorPagePart diagramPart, String connId) {
        int connIndex;
        int index = connId.indexOf(CONNECTION_ID_SEPARATOR);
        if (index == -1) {
            return null;
        }
        String connPartId = connId.substring(0, index);
        String subId = connId.substring(index + 1);
        try {
            connIndex = Integer.valueOf(subId);
        }
        catch (NumberFormatException numberFormatException) {
            connIndex = -1;
        }
        for (DiagramConnectionTemplate connTemplate : diagramPart.getConnectionTemplates()) {
            if (!connTemplate.getConnectionTypeId().equals(connPartId)) continue;
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(null);
            int i = 0;
            while (i < connParts.size()) {
                DiagramConnectionPart connPart = connParts.get(i);
                String connId2 = connPart.getInstanceId();
                if (subId != null && connId2 != null && subId.equals(connId2)) {
                    return connPart;
                }
                if (i == connIndex) {
                    return connPart;
                }
                ++i;
            }
        }
        return null;
    }

    public static DiagramConnectionPart getConnectionPart(DiagramNodePart nodePart, String connId) {
        int connIndex;
        int index = connId.indexOf(CONNECTION_ID_SEPARATOR);
        if (index == -1) {
            return null;
        }
        String connPartId = connId.substring(0, index);
        String subId = connId.substring(index + 1);
        try {
            connIndex = Integer.valueOf(subId);
        }
        catch (NumberFormatException numberFormatException) {
            connIndex = -1;
        }
        DiagramNodeTemplate nodeTemplate = nodePart.getDiagramNodeTemplate();
        DiagramEmbeddedConnectionTemplate connTemplate = nodeTemplate.getEmbeddedConnectionTemplate();
        if (connTemplate != null && connTemplate.getConnectionTypeId().equals(connPartId)) {
            List<DiagramConnectionPart> connParts = connTemplate.getDiagramConnections(nodePart.getLocalModelElement());
            int i = 0;
            while (i < connParts.size()) {
                DiagramConnectionPart connPart = connParts.get(i);
                String connId2 = connPart.getInstanceId();
                if (subId != null && connId2 != null && subId.equals(connId2)) {
                    return connPart;
                }
                if (i == connIndex) {
                    return connPart;
                }
                ++i;
            }
        }
        return null;
    }
}

