/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageChoice;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramPageEvent;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDiagramEditorPagePart
extends SapphireEditorPagePart {
    private IModelElement modelElement;
    private IDiagramEditorPageDef diagramPageDef = null;
    private List<IDiagramNodeDef> nodeDefs;
    private List<IDiagramConnectionDef> connectionDefs;
    private List<DiagramNodeTemplate> nodeTemplates;
    private Map<DiagramNodeTemplate, FunctionResult> nodeTemplateFunctionResults;
    private List<DiagramConnectionTemplate> connectionTemplates;
    private List<DiagramImplicitConnectionTemplate> implicitConnectionTemplates;
    private NodeTemplateListener nodeTemplateListener;
    private ConnectionTemplateListener connTemplateListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private SapphirePart selection;
    private ImplicitConnectionTemplateListener implicitConnTemplateListener;
    private boolean showGrid;
    private boolean showGuides;

    @Override
    protected void init() {
        super.init();
        this.diagramPageDef = (IDiagramEditorPageDef)this.definition;
        ImpliedElementProperty modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.diagramPageDef.getProperty().getContent());
        this.modelElement = modelElementProperty != null ? this.getModelElement().read(modelElementProperty) : this.getModelElement();
        this.showGrid = (Boolean)this.diagramPageDef.getGridDefinition().isVisible().getContent();
        this.showGuides = (Boolean)this.diagramPageDef.getGuidesDefinition().isVisible().getContent();
        this.nodeTemplateListener = new NodeTemplateListener();
        this.connTemplateListener = new ConnectionTemplateListener();
        this.implicitConnTemplateListener = new ImplicitConnectionTemplateListener();
        this.nodeTemplates = new ArrayList<DiagramNodeTemplate>();
        this.nodeTemplateFunctionResults = new HashMap<DiagramNodeTemplate, FunctionResult>();
        this.nodeDefs = this.diagramPageDef.getDiagramNodeDefs();
        this.connectionDefs = this.diagramPageDef.getDiagramConnectionDefs();
        for (IDiagramNodeDef nodeDef : this.nodeDefs) {
            final DiagramNodeTemplate nodeTemplate = new DiagramNodeTemplate();
            nodeTemplate.init(this, this.modelElement, nodeDef, Collections.<String, String>emptyMap());
            this.nodeTemplates.add(nodeTemplate);
            nodeTemplate.addTemplateListener(this.nodeTemplateListener);
            FunctionResult visibleWhen = null;
            if (nodeDef.getVisibleWhen().getContent() == null) continue;
            visibleWhen = this.initExpression(this.modelElement, (Function)nodeDef.getVisibleWhen().getContent(), String.class, null, new Runnable(){

                public void run() {
                    SapphireDiagramEditorPagePart.this.refreshDiagramPalette(nodeTemplate);
                }
            });
            this.nodeTemplateFunctionResults.put(nodeTemplate, visibleWhen);
        }
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            nodeTemplate.initEmbeddedConnections();
            if (nodeTemplate.getEmbeddedConnectionTemplate() == null) continue;
            nodeTemplate.getEmbeddedConnectionTemplate().addTemplateListener(this.connTemplateListener);
        }
        this.connectionTemplates = new ArrayList<DiagramConnectionTemplate>();
        ModelElementList<IDiagramExplicitConnectionBindingDef> connectionBindings = this.diagramPageDef.getDiagramConnectionBindingDefs();
        for (IDiagramExplicitConnectionBindingDef connBinding : connectionBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)connBinding.getConnectionId().getContent());
            DiagramConnectionTemplate connectionTemplate = new DiagramConnectionTemplate(connBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.connectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.connTemplateListener);
        }
        this.implicitConnectionTemplates = new ArrayList<DiagramImplicitConnectionTemplate>();
        ModelElementList<IDiagramImplicitConnectionBindingDef> implicitConnBindings = this.diagramPageDef.getImplicitConnectionBindingDefs();
        for (IDiagramImplicitConnectionBindingDef implicitConnBinding : implicitConnBindings) {
            IDiagramConnectionDef connDef = this.getDiagramConnectionDef((String)implicitConnBinding.getConnectionId().getContent());
            DiagramImplicitConnectionTemplate connectionTemplate = new DiagramImplicitConnectionTemplate(implicitConnBinding);
            connectionTemplate.init(this, this.modelElement, connDef, Collections.<String, String>emptyMap());
            this.implicitConnectionTemplates.add(connectionTemplate);
            connectionTemplate.addTemplateListener(this.implicitConnTemplateListener);
        }
        this.selection = this;
        this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.modelElement);
        this.addListener(new SapphirePartListener(){

            public void handleEvent(SapphirePartEvent event) {
                if (event instanceof SapphireEditorPagePart.SelectionChangedEvent) {
                    SapphireDiagramEditorPagePart.this.refreshPropertiesViewContribution();
                }
            }
        });
        this.refreshPropertiesViewContribution();
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public boolean isGridVisible() {
        return this.showGrid;
    }

    public void syncGridStateWithDiagramLayout(boolean gridVisible) {
        this.showGrid = gridVisible;
    }

    public void setGridVisible(boolean visible) {
        if (visible != this.showGrid) {
            this.showGrid = visible;
            this.notifyGridStateChange();
        }
    }

    public boolean isShowGuides() {
        return this.showGuides;
    }

    public void setShowGuides(boolean showGuides) {
        if (this.showGuides != showGuides) {
            this.showGuides = showGuides;
            this.notifyGuideStateChange();
        }
    }

    public void syncGuideStateWithDiagramLayout(boolean showGuides) {
        this.showGuides = showGuides;
    }

    public List<IDiagramImageChoice> getImageDecorators() {
        return this.diagramPageDef.getDiagramImageDecorators();
    }

    public List<DiagramNodeTemplate> getNodeTemplates() {
        return this.nodeTemplates;
    }

    public List<DiagramNodeTemplate> getVisibleNodeTemplates() {
        ArrayList<DiagramNodeTemplate> visibleNodeTemplates = new ArrayList<DiagramNodeTemplate>();
        for (DiagramNodeTemplate nodeTemplate : this.getNodeTemplates()) {
            if (!this.isNodeTemplateVisible(nodeTemplate)) continue;
            visibleNodeTemplates.add(nodeTemplate);
        }
        return visibleNodeTemplates;
    }

    public boolean isNodeTemplateVisible(DiagramNodeTemplate nodeTemplate) {
        String valStr;
        boolean visible = true;
        FunctionResult fr = this.nodeTemplateFunctionResults.get(nodeTemplate);
        if (fr != null && (valStr = (String)fr.value()) != null && valStr.equals("false")) {
            visible = false;
        }
        return visible;
    }

    public List<IDiagramConnectionDef> getDiagramConnectionDefs() {
        return this.connectionDefs;
    }

    public IDiagramConnectionDef getDiagramConnectionDef(String connId) {
        if (connId == null) {
            throw new IllegalArgumentException();
        }
        IDiagramConnectionDef connDef = null;
        for (IDiagramConnectionDef def : this.connectionDefs) {
            String id = (String)def.getId().getContent();
            if (id == null || !id.equalsIgnoreCase(connId)) continue;
            connDef = def;
            break;
        }
        return connDef;
    }

    public List<DiagramConnectionTemplate> getConnectionTemplates() {
        return this.connectionTemplates;
    }

    public List<DiagramImplicitConnectionTemplate> getImplicitConnectionTemplates() {
        return this.implicitConnectionTemplates;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram");
        contextSet.add("Sapphire.Diagram.Editor");
        return contextSet;
    }

    public SapphirePart getSelection() {
        return this.selection;
    }

    public void setSelection(SapphirePart selection) {
        if (this.selection != selection) {
            SapphirePart newSelection;
            SapphirePart oldSelection = this.selection;
            this.selection = newSelection = selection;
            this.notifyListeners(new SapphireEditorPagePart.SelectionChangedEvent(this, oldSelection, newSelection));
        }
    }

    private void refreshPropertiesViewContribution() {
        SapphirePart selection = this.getSelection();
        PropertiesViewContributionPart propertiesViewContribution = null;
        if (selection == this) {
            propertiesViewContribution = this.propertiesViewContributionManager.getPropertiesViewContribution();
        } else if (selection instanceof IPropertiesViewContributorPart) {
            propertiesViewContribution = ((IPropertiesViewContributorPart)((Object)selection)).getPropertiesViewContribution();
        }
        this.setPropertiesViewContribution(propertiesViewContribution);
    }

    private void refreshDiagramPalette(DiagramNodeTemplate nodeTemplate) {
        if (this.isNodeTemplateVisible(nodeTemplate)) {
            nodeTemplate.showAllNodeParts();
            List<DiagramConnectionTemplate> connTemplates = this.getConnectionTemplates();
            for (DiagramConnectionTemplate connTemplate : connTemplates) {
                connTemplate.showAllConnectionParts(nodeTemplate);
            }
            List<DiagramImplicitConnectionTemplate> implictConnTemplates = this.getImplicitConnectionTemplates();
            for (DiagramImplicitConnectionTemplate implicitConnTemplate : implictConnTemplates) {
                implicitConnTemplate.refreshImplicitConnections();
            }
        } else {
            nodeTemplate.hideAllNodeParts();
        }
        this.notifyDiagramChange();
        this.refreshPropertiesViewContribution();
    }

    public DiagramNodePart getDiagramNodePart(IModelElement nodeElement) {
        if (nodeElement == null) {
            return null;
        }
        List<DiagramNodeTemplate> nodeTemplates = this.getNodeTemplates();
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            List<DiagramNodePart> nodeParts = nodeTemplate.getDiagramNodes();
            for (DiagramNodePart nodePart : nodeParts) {
                if (!nodePart.getLocalModelElement().equals(nodeElement)) continue;
                return nodePart;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeParts();
    }

    private void disposeParts() {
        for (DiagramNodeTemplate diagramNodeTemplate : this.nodeTemplates) {
            FunctionResult fr = this.nodeTemplateFunctionResults.get(diagramNodeTemplate);
            if (fr != null) {
                fr.dispose();
            }
            diagramNodeTemplate.dispose();
        }
        this.nodeTemplates.clear();
        for (DiagramConnectionTemplate diagramConnectionTemplate : this.connectionTemplates) {
            diagramConnectionTemplate.dispose();
        }
        this.connectionTemplates.clear();
        for (DiagramImplicitConnectionTemplate diagramImplicitConnectionTemplate : this.implicitConnectionTemplates) {
            diagramImplicitConnectionTemplate.dispose();
        }
        this.implicitConnectionTemplates.clear();
    }

    public DiagramNodeTemplate getNodeTemplate(ModelProperty modelProperty) {
        for (DiagramNodeTemplate nodeTemplate : this.nodeTemplates) {
            if (nodeTemplate.getModelProperty() != modelProperty) continue;
            return nodeTemplate;
        }
        return null;
    }

    private void notifyNodeUpdate(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeUpdateEvent(nue);
        }
    }

    private void notifyNodeAdd(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeAddEvent(nue);
        }
    }

    private void notifyNodeDelete(DiagramNodePart nodePart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(nodePart);
            ((SapphireDiagramPartListener)listener).handleNodeDeleteEvent(nue);
        }
    }

    private void notifyNodeMove(DiagramNodeEvent event) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            ((SapphireDiagramPartListener)listener).handleNodeMoveEvent(event);
        }
    }

    private void notifyConnectionUpdate(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionUpdateEvent(cue);
        }
    }

    private void notifyConnectionEndpointUpdate(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionEndpointEvent(cue);
        }
    }

    private void notifyConnectionAdd(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionAddEvent(cue);
        }
    }

    private void notifyConnectionDelete(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionDeleteEvent(cue);
        }
    }

    private void notifyConnectionAddBendpoint(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionAddBendpointEvent(cue);
        }
    }

    private void notifyConnectionRemoveBendpoint(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionRemoveBendpointEvent(cue);
        }
    }

    private void notifyConnectionMoveBendpoint(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionMoveBendpointEvent(cue);
        }
    }

    private void notifyConnectionMoveLabel(DiagramConnectionPart connPart) {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(connPart);
            ((SapphireDiagramPartListener)listener).handleConnectionMoveLabelEvent(cue);
        }
    }

    private void notifyGridStateChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleGridStateChangeEvent(pageEvent);
        }
    }

    private void notifyGuideStateChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleGuideStateChangeEvent(pageEvent);
        }
    }

    private void notifyDiagramChange() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramPageEvent pageEvent = new DiagramPageEvent(this);
            ((SapphireDiagramPartListener)listener).handleDiagramUpdateEvent(pageEvent);
        }
    }

    private class ConnectionTemplateListener
    extends DiagramConnectionTemplate.Listener {
        private ConnectionTemplateListener() {
        }

        public void handleConnectionUpdate(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionUpdate(connPart);
        }

        public void handleConnectionEndpointUpdate(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionEndpointUpdate(connPart);
        }

        public void handleConnectionAdd(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(connPart);
        }

        public void handleConnectionDelete(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(connPart);
        }

        public void handleAddBendpoint(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAddBendpoint(connPart);
        }

        public void handleRemoveBendpoint(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionRemoveBendpoint(connPart);
        }

        public void handleMoveBendpoint(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionMoveBendpoint(connPart);
        }

        public void handleMoveLabel(DiagramConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionMoveLabel(connPart);
        }
    }

    private class ImplicitConnectionTemplateListener
    extends DiagramImplicitConnectionTemplate.Listener {
        private ImplicitConnectionTemplateListener() {
        }

        public void handleConnectionAdd(DiagramImplicitConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionAdd(connPart);
        }

        public void handleConnectionDelete(DiagramImplicitConnectionPart connPart) {
            SapphireDiagramEditorPagePart.this.notifyConnectionDelete(connPart);
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.Listener {
        private NodeTemplateListener() {
        }

        public void handleNodeUpdate(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeUpdate(nodePart);
        }

        public void handleNodeAdd(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeAdd(nodePart);
        }

        public void handleNodeDelete(DiagramNodePart nodePart) {
            SapphireDiagramEditorPagePart.this.notifyNodeDelete(nodePart);
        }

        public void handleNodeMove(DiagramNodeEvent event) {
            SapphireDiagramEditorPagePart.this.notifyNodeMove(event);
        }
    }
}

