/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.geometry.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.ui.diagram.geometry.IBendPoint;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramConnectionGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramConnectionGeometry
extends ModelElement
implements IDiagramConnectionGeometry {
    private ModelElementList<IBendPoint> connectionBendpoints;
    private Value<String> connectionId;
    private Value<Integer> labelX;
    private Value<Integer> labely;

    public DiagramConnectionGeometry(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DiagramConnectionGeometry(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IBendPoint> getConnectionBendpoints() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.connectionBendpoints == null) {
                this.refresh((ModelProperty)PROP_CONNECTION_BENDPOINTS, true);
            }
            return this.connectionBendpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getConnectionId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.connectionId == null) {
                this.refresh((ModelProperty)PROP_CONNECTION_ID, true);
            }
            return this.connectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CONNECTION_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CONNECTION_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CONNECTION_ID, true);
            if (!DiagramConnectionGeometry.equal((String)this.connectionId.getText(false), (String)value)) {
                this.resource().binding(PROP_CONNECTION_ID).write(value);
                this.refresh((ModelProperty)PROP_CONNECTION_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getLabelX() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.labelX == null) {
                this.refresh((ModelProperty)PROP_LABEL_X, true);
            }
            return this.labelX;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabelX(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LABEL_X.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_LABEL_X, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_LABEL_X, true);
            if (!DiagramConnectionGeometry.equal((String)this.labelX.getText(false), (String)value)) {
                this.resource().binding(PROP_LABEL_X).write(value);
                this.refresh((ModelProperty)PROP_LABEL_X, false);
            }
        }
    }

    @Override
    public void setLabelX(Integer value) {
        this.setLabelX(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_LABEL_X, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getLabelY() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.labely == null) {
                this.refresh((ModelProperty)PROP_LabelY, true);
            }
            return this.labely;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabelY(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LabelY.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_LabelY, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_LabelY, true);
            if (!DiagramConnectionGeometry.equal((String)this.labely.getText(false), (String)value)) {
                this.resource().binding(PROP_LabelY).write(value);
                this.refresh((ModelProperty)PROP_LabelY, false);
            }
        }
    }

    @Override
    public void setLabelY(Integer value) {
        this.setLabelY(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_LabelY, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CONNECTION_BENDPOINTS) {
                if (this.connectionBendpoints == null) {
                    if (force) {
                        this.connectionBendpoints = new ModelElementList((IModelElement)this, PROP_CONNECTION_BENDPOINTS);
                        ListBindingImpl binding = this.resource().binding(PROP_CONNECTION_BENDPOINTS);
                        this.connectionBendpoints.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_BENDPOINTS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_BENDPOINTS);
                    boolean notified = this.connectionBendpoints.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTION_BENDPOINTS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_CONNECTION_ID) {
                if (this.connectionId != null || force) {
                    Value<String> oldValue = this.connectionId;
                    String val = this.resource().binding(PROP_CONNECTION_ID).read();
                    this.connectionId = new Value((IModelElement)this, PROP_CONNECTION_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_CONNECTION_ID, ValueNormalizationService.class)).normalize(PROP_CONNECTION_ID.encodeKeywords(val)));
                    this.connectionId.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CONNECTION_ID);
                    if (oldValue != null) {
                        if (this.connectionId.equals(oldValue)) {
                            this.connectionId = oldValue;
                        }
                        if (this.connectionId != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTION_ID, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_LABEL_X) {
                if (this.labelX != null || force) {
                    Value<Integer> oldValue = this.labelX;
                    String val = this.resource().binding(PROP_LABEL_X).read();
                    this.labelX = new Value((IModelElement)this, PROP_LABEL_X, ((ValueNormalizationService)this.service((ModelProperty)PROP_LABEL_X, ValueNormalizationService.class)).normalize(PROP_LABEL_X.encodeKeywords(val)));
                    this.labelX.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_LABEL_X);
                    if (oldValue != null) {
                        if (this.labelX.equals(oldValue)) {
                            this.labelX = oldValue;
                        }
                        if (this.labelX != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LABEL_X, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_LabelY && (this.labely != null || force)) {
                Value<Integer> oldValue = this.labely;
                String val = this.resource().binding(PROP_LabelY).read();
                this.labely = new Value((IModelElement)this, PROP_LabelY, ((ValueNormalizationService)this.service((ModelProperty)PROP_LabelY, ValueNormalizationService.class)).normalize(PROP_LabelY.encodeKeywords(val)));
                this.labely.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_LabelY);
                if (oldValue != null) {
                    if (this.labely.equals(oldValue)) {
                        this.labely = oldValue;
                    }
                    if (this.labely != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_LabelY, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CONNECTION_BENDPOINTS) {
            return this.getConnectionBendpoints();
        }
        if (property == PROP_CONNECTION_ID) {
            return this.getConnectionId();
        }
        if (property == PROP_LABEL_X) {
            return this.getLabelX();
        }
        if (property == PROP_LabelY) {
            return this.getLabelY();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CONNECTION_ID) {
            this.setConnectionId((String)value);
            return;
        }
        if (property == PROP_LABEL_X) {
            if (!(value instanceof String)) {
                this.setLabelX((Integer)value);
            } else {
                this.setLabelX((String)value);
            }
            return;
        }
        if (property == PROP_LabelY) {
            if (!(value instanceof String)) {
                this.setLabelY((Integer)value);
            } else {
                this.setLabelY((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

