/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.geometry.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.ui.diagram.def.IDiagramGridDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramGuidesDef;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramConnectionGeometry;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramGeometry;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramNodeGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramGeometry
extends ModelElement
implements IDiagramGeometry {
    private ModelElementList<IDiagramConnectionGeometry> diagramConnectionGeometries;
    private ModelElementList<IDiagramNodeGeometry> diagramNodeGeometries;
    private ModelElementHandle<IDiagramGridDef> gridDefinition;
    private ModelElementHandle<IDiagramGuidesDef> guidesDefinition;

    public DiagramGeometry(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DiagramGeometry(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IDiagramConnectionGeometry> getDiagramConnectionGeometries() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.diagramConnectionGeometries == null) {
                this.refresh((ModelProperty)PROP_DIAGRAM_CONNECTION_GEOMETRIES, true);
            }
            return this.diagramConnectionGeometries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IDiagramNodeGeometry> getDiagramNodeGeometries() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.diagramNodeGeometries == null) {
                this.refresh((ModelProperty)PROP_DIAGRAM_NODE_GEOMETRIES, true);
            }
            return this.diagramNodeGeometries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDiagramGridDef getGridDefinition() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.gridDefinition == null) {
                this.refresh((ModelProperty)PROP_GRID_DEFINITION, true);
            }
            return (IDiagramGridDef)this.gridDefinition.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDiagramGuidesDef getGuidesDefinition() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.guidesDefinition == null) {
                this.refresh((ModelProperty)PROP_GUIDES_DEFINITION, true);
            }
            return (IDiagramGuidesDef)this.guidesDefinition.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DIAGRAM_CONNECTION_GEOMETRIES) {
                if (this.diagramConnectionGeometries == null) {
                    if (force) {
                        this.diagramConnectionGeometries = new ModelElementList((IModelElement)this, PROP_DIAGRAM_CONNECTION_GEOMETRIES);
                        ListBindingImpl binding = this.resource().binding(PROP_DIAGRAM_CONNECTION_GEOMETRIES);
                        this.diagramConnectionGeometries.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DIAGRAM_CONNECTION_GEOMETRIES);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DIAGRAM_CONNECTION_GEOMETRIES);
                    boolean notified = this.diagramConnectionGeometries.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DIAGRAM_CONNECTION_GEOMETRIES, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_DIAGRAM_NODE_GEOMETRIES) {
                if (this.diagramNodeGeometries == null) {
                    if (force) {
                        this.diagramNodeGeometries = new ModelElementList((IModelElement)this, PROP_DIAGRAM_NODE_GEOMETRIES);
                        ListBindingImpl binding = this.resource().binding(PROP_DIAGRAM_NODE_GEOMETRIES);
                        this.diagramNodeGeometries.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DIAGRAM_NODE_GEOMETRIES);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DIAGRAM_NODE_GEOMETRIES);
                    boolean notified = this.diagramNodeGeometries.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DIAGRAM_NODE_GEOMETRIES, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_GRID_DEFINITION) {
                if (this.gridDefinition == null) {
                    if (force) {
                        this.gridDefinition = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_GRID_DEFINITION);
                        this.gridDefinition.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_GRID_DEFINITION);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_GRID_DEFINITION);
                    boolean notified = this.gridDefinition.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_GRID_DEFINITION, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_GUIDES_DEFINITION) {
                if (this.guidesDefinition == null) {
                    if (force) {
                        this.guidesDefinition = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_GUIDES_DEFINITION);
                        this.guidesDefinition.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_GUIDES_DEFINITION);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_GUIDES_DEFINITION);
                    boolean notified = this.guidesDefinition.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_GUIDES_DEFINITION, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DIAGRAM_CONNECTION_GEOMETRIES) {
            return this.getDiagramConnectionGeometries();
        }
        if (property == PROP_DIAGRAM_NODE_GEOMETRIES) {
            return this.getDiagramNodeGeometries();
        }
        if (property == PROP_GRID_DEFINITION) {
            return this.getGridDefinition();
        }
        if (property == PROP_GUIDES_DEFINITION) {
            return this.getGuidesDefinition();
        }
        return super.read(property);
    }
}

