/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutlineNodeAddActionHandlerFactory
extends SapphireActionHandlerFactory {
    public static final String ID_BASE = "Sapphire.Add.";
    private Map<ModelProperty, PossibleTypesService> propertyToPossibleTypesServiceMap;
    private Listener possibleTypesServiceListener;

    @Override
    public void init(SapphireAction action, ISapphireActionHandlerFactoryDef def) {
        super.init(action, def);
        this.possibleTypesServiceListener = new Listener(){

            public void handle(Event event) {
                OutlineNodeAddActionHandlerFactory.this.broadcast(new Event());
            }
        };
        this.propertyToPossibleTypesServiceMap = new HashMap<ModelProperty, PossibleTypesService>();
        MasterDetailsContentNode node = (MasterDetailsContentNode)this.getPart();
        IModelElement element = node.getLocalModelElement();
        for (ModelProperty property : node.getChildNodeFactoryProperties()) {
            PossibleTypesService possibleTypesService = (PossibleTypesService)element.service(property, PossibleTypesService.class);
            possibleTypesService.attach(this.possibleTypesServiceListener);
            this.propertyToPossibleTypesServiceMap.put(property, possibleTypesService);
        }
    }

    @Override
    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        for (Map.Entry<ModelProperty, PossibleTypesService> entry : this.propertyToPossibleTypesServiceMap.entrySet()) {
            AbstractActionHandler handler;
            ListProperty prop;
            ModelProperty property = entry.getKey();
            PossibleTypesService possibleTypesService = entry.getValue();
            if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                for (ModelElementType memberType : possibleTypesService.types()) {
                    handler = new ListPropertyActionHandler(prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                prop = (ElementProperty)property;
                for (ModelElementType memberType : possibleTypesService.types()) {
                    handler = new ElementPropertyActionHandler((ElementProperty)prop, memberType);
                    handlers.add(handler);
                }
                continue;
            }
            throw new IllegalStateException();
        }
        return handlers;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (PossibleTypesService possibleTypesService : this.propertyToPossibleTypesServiceMap.values()) {
            possibleTypesService.detach(this.possibleTypesServiceListener);
        }
    }

    private static abstract class AbstractActionHandler
    extends SapphireActionHandler {
        private final ModelProperty property;
        private final ModelElementType type;
        private MasterDetailsContentOutline contentTree;

        public AbstractActionHandler(ModelProperty property, ModelElementType type) {
            this.property = property;
            this.type = type;
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            this.setId(OutlineNodeAddActionHandlerFactory.ID_BASE + this.type.getSimpleName());
            this.setLabel(this.type.getLabel(true, CapitalizationType.NO_CAPS, false));
            ImageDescriptor typeSpecificAddImage = SwtRendererUtil.toImageDescriptor(this.type.image());
            if (typeSpecificAddImage != null) {
                this.addImage(typeSpecificAddImage);
            }
            this.contentTree = ((MasterDetailsContentNode)this.getPart()).getContentTree();
            final MasterDetailsContentOutline.Listener contentTreeListener = new MasterDetailsContentOutline.Listener(){

                public void handleFilterChange(String newFilterText) {
                    AbstractActionHandler.this.refreshEnablementState();
                }
            };
            this.contentTree.addListener(contentTreeListener);
            this.refreshEnablementState();
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        AbstractActionHandler.this.contentTree.removeListener(contentTreeListener);
                    }
                }
            });
        }

        protected final void refreshEnablementState() {
            this.setEnabled(this.computeEnablementState());
        }

        protected boolean computeEnablementState() {
            return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
        }

        public ModelProperty property() {
            return this.property;
        }

        protected final Object run(SapphireRenderingContext context) {
            IModelElement newModelElement;
            MasterDetailsContentNode node;
            block4: {
                node = (MasterDetailsContentNode)this.getPart();
                IModelElement element = node.getLocalModelElement();
                newModelElement = null;
                try {
                    newModelElement = this.create(element, this.property, this.type);
                }
                catch (Exception e) {
                    EditFailedException editFailedException = EditFailedException.findAsCause((Throwable)e);
                    if (editFailedException != null) break block4;
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (newModelElement != null) {
                node.getContentTree().notifyOfNodeStructureChange(node);
                for (MasterDetailsContentNode n : node.getChildNodes()) {
                    if (n.getModelElement() != newModelElement) continue;
                    n.select();
                    this.getPart().nearest(MasterDetailsEditorPagePart.class).setFocusOnDetails();
                    break;
                }
            }
            return newModelElement;
        }

        protected abstract IModelElement create(IModelElement var1, ModelProperty var2, ModelElementType var3);
    }

    private static final class ElementPropertyActionHandler
    extends AbstractActionHandler {
        public ElementPropertyActionHandler(ElementProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            final ModelPropertyListener listener = new ModelPropertyListener(){

                public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                    ElementPropertyActionHandler.this.refreshEnablementState();
                }
            };
            final IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
            element.addListener(listener, this.property().getName());
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof DisposeEvent) {
                        element.removeListener(listener, ElementPropertyActionHandler.this.property().getName());
                    }
                }
            });
        }

        public ElementProperty property() {
            return (ElementProperty)super.property();
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ElementProperty)property).element(true, type);
        }

        protected boolean computeEnablementState() {
            boolean state = super.computeEnablementState();
            if (state) {
                IModelElement element = ((MasterDetailsContentNode)this.getPart()).getLocalModelElement();
                ModelElementHandle handle = element.read(this.property());
                state = handle.element() == null;
            }
            return state;
        }
    }

    private static final class ListPropertyActionHandler
    extends AbstractActionHandler {
        public ListPropertyActionHandler(ListProperty property, ModelElementType type) {
            super((ModelProperty)property, type);
        }

        protected IModelElement create(IModelElement element, ModelProperty property, ModelElementType type) {
            return element.read((ListProperty)property).addNewElement(type);
        }
    }
}

