/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.DefaultValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.actions.RelativePathBrowseActionHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public final class EclipseWorkspacePathPropertyEditorRenderer
extends DefaultValuePropertyEditorRenderer {
    public EclipseWorkspacePathPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        Value value;
        String val;
        SapphirePropertyEditor part = this.getPart();
        IModelElement element = part.getLocalModelElement();
        ModelProperty property = part.getProperty();
        final Text textField = (Text)super.createContents(parent, true);
        Composite drillDownParent = this.createMainComposite(parent, new PropertyEditorRenderer.CreateMainCompositeDelegate(this, part){

            public boolean getShowLabel() {
                return false;
            }
        });
        drillDownParent.setLayout((Layout)GridLayoutUtil.glayout(1, 9, 0, 0, 0));
        DrillDownComposite drillDown = new DrillDownComposite(drillDownParent, 2048);
        drillDown.setLayoutData((Object)GridLayoutUtil.gdfill());
        final TreeViewer treeViewer = new TreeViewer((Composite)drillDown, 0);
        Tree tree = treeViewer.getTree();
        drillDown.setChildTree(treeViewer);
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        treeViewer.setSorter(new ViewerSorter());
        ValidFileSystemResourceType validFileSystemResourceTypeAnnotation = (ValidFileSystemResourceType)property.getAnnotation(ValidFileSystemResourceType.class);
        if (validFileSystemResourceTypeAnnotation != null) {
            FileExtensionsService fileExtensionsService;
            if (validFileSystemResourceTypeAnnotation.value() == FileSystemResourceType.FOLDER) {
                treeViewer.addFilter((ViewerFilter)new RelativePathBrowseActionHandler.ContainersOnlyViewerFilter());
            }
            if ((fileExtensionsService = (FileExtensionsService)element.service(property, FileExtensionsService.class)) != null) {
                final RelativePathBrowseActionHandler.ExtensionBasedViewerFilter filter = new RelativePathBrowseActionHandler.ExtensionBasedViewerFilter(fileExtensionsService.extensions());
                treeViewer.addFilter((ViewerFilter)filter);
                final Listener listener = new Listener(){

                    public void handle(Event event) {
                        filter.change(fileExtensionsService.extensions());
                        treeViewer.refresh();
                    }
                };
                fileExtensionsService.attach(listener);
                tree.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        fileExtensionsService.detach(listener);
                    }
                });
            }
        }
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    Object item = selection.getFirstElement();
                    if (treeViewer.getExpandedState(item)) {
                        treeViewer.collapseToLevel(item, 1);
                    } else {
                        treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.decorator.addEditorControl((Control)drillDown);
        this.decorator.addEditorControl((Control)tree);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IResource resource;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String path = "";
                if (selection != null && !selection.isEmpty() && (path = (resource = (IResource)selection.getFirstElement()).getFullPath().toPortableString()).startsWith("/") && path.length() > 1) {
                    path = path.substring(1);
                }
                textField.setText(path);
            }
        });
        textField.setData("binding", (Object)this.binding);
        this.addControl((Control)tree);
        IModelElement modelElement = this.getModelElement();
        if (modelElement != null && (val = (value = modelElement.read(this.getProperty())).getText()) != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(val);
            if (resource instanceof IFile && validFileSystemResourceTypeAnnotation.value() == FileSystemResourceType.FOLDER) {
                resource = resource.getParent();
            }
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
    }

    protected boolean canScaleVertically() {
        return true;
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return true;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new EclipseWorkspacePathPropertyEditorRenderer(context, part);
        }
    }
}

