/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.binding.ComboBinding;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroup;
import org.eclipse.sapphire.ui.internal.binding.RadioButtonsGroupBinding;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class EnumPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Control control;

    public EnumPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean showLabel = part.getShowLabel();
        int leftMargin = part.getMarginLeft();
        boolean preferVerticalRadioButtonBinding = part.getRenderingHint("prefer.vertical.radio.buttons", false);
        boolean preferRadioButtonBinding = part.getRenderingHint("prefer.radio.buttons", false);
        boolean preferComboBinding = part.getRenderingHint("prefer.combo", false);
        Enum[] enumValues = (Enum[])property.getTypeClass().getEnumConstants();
        PropertyEditorAssistDecorator decorator = null;
        if (preferVerticalRadioButtonBinding) {
            Composite composite = this.createMainComposite(parent, new PropertyEditorRenderer.CreateMainCompositeDelegate(this, part){

                public boolean getShowLabel() {
                    return false;
                }

                public boolean getSpanBothColumns() {
                    return true;
                }
            });
            composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2, 5));
            decorator = this.createDecorator(composite);
            decorator.addEditorControl((Control)composite);
            if (showLabel) {
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
                Label label = new Label(composite, 64);
                label.setLayoutData((Object)GridLayoutUtil.gd());
                label.setText(part.getLabel(CapitalizationType.FIRST_WORD_ONLY, true));
                decorator.addEditorControl((Control)label);
            } else {
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), 4));
            }
            this.control = new RadioButtonsGroup(this.context, composite, true);
            if (showLabel) {
                this.control.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), leftMargin + 20));
            } else {
                this.control.setLayoutData((Object)GridLayoutUtil.gdhfill());
            }
            this.context.adapt(this.control);
        } else {
            Composite composite = this.createMainComposite(parent);
            composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
            decorator = this.createDecorator(composite);
            decorator.addEditorControl((Control)composite);
            if (preferRadioButtonBinding || enumValues.length <= 3 && !preferComboBinding) {
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
                RadioButtonsGroup buttonsGroup = new RadioButtonsGroup(this.context, composite, false);
                buttonsGroup.setLayoutData(GridLayoutUtil.gdhfill());
                this.context.adapt((Control)buttonsGroup);
                this.control = buttonsGroup;
            } else {
                decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
                Combo c = new Combo(composite, 2060);
                c.setLayoutData((Object)GridLayoutUtil.gdhfill());
                c.setVisibleItemCount(10);
                this.context.adapt((Control)c);
                this.control = c;
            }
        }
        this.binding = this.control instanceof RadioButtonsGroup ? new RadioButtonsGroupBinding(this.getPart(), this.context, (RadioButtonsGroup)this.control) : new ComboBinding(this.getPart(), this.context, (Combo)this.control);
        this.control.setData("binding", (Object)this.binding);
        decorator.addEditorControl(this.control, true);
        this.addControl(this.control);
    }

    protected void handleFocusReceivedEvent() {
        this.control.setFocus();
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.isOfType(Enum.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new EnumPropertyEditorRenderer(context, part);
        }
    }
}

