/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.AbstractSlushBucketPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValueLabelProvider;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class SlushBucketPropertyEditor
extends AbstractSlushBucketPropertyEditorRenderer {
    private ModelElementType memberType = this.getProperty().getType();
    private ValueProperty memberProperty = (ValueProperty)this.memberType.getProperties().get(0);
    private PossibleValuesService possibleValuesService;
    private Listener possibleValuesServiceListener;
    private TableViewer sourceTableViewer;
    private Table sourceTable;
    private MoveRightActionHandler moveRightActionHandler;

    public SlushBucketPropertyEditor(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
        this.possibleValuesService = (PossibleValuesService)part.getLocalModelElement().service((ModelProperty)this.memberProperty, PossibleValuesService.class);
        this.setAddActionDesired(false);
    }

    public Control createSourceControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        innerComposite.setLayout((Layout)tableColumnLayout);
        this.sourceTableViewer = new TableViewer(innerComposite, 67586);
        this.sourceTable = this.sourceTableViewer.getTable();
        this.sourceTable.setHeaderVisible(true);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.sourceTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Collection<Object> values;
                SortedSet allValues;
                if (SlushBucketPropertyEditor.this.possibleValuesService == null) {
                    return new Object[0];
                }
                ModelElementList<IModelElement> list = SlushBucketPropertyEditor.this.getList();
                if (list == null) {
                    return new Object[0];
                }
                try {
                    allValues = SlushBucketPropertyEditor.this.possibleValuesService.values();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                    return new Object[0];
                }
                HashSet<String> valuesToRemove = new HashSet<String>();
                for (IModelElement member : list) {
                    String str = member.read(SlushBucketPropertyEditor.this.memberProperty).getText();
                    if (str == null) continue;
                    valuesToRemove.add(str);
                }
                if (SlushBucketPropertyEditor.this.possibleValuesService.isCaseSensitive()) {
                    values = new HashSet(allValues);
                    values.removeAll(valuesToRemove);
                } else {
                    HashMap<String, String> valuesLowerCaseToOriginalCase = new HashMap<String, String>();
                    for (String value : allValues) {
                        valuesLowerCaseToOriginalCase.put(value.toLowerCase(), value);
                    }
                    for (String valueToRemove : valuesToRemove) {
                        valuesLowerCaseToOriginalCase.remove(valueToRemove.toLowerCase());
                    }
                    values = valuesLowerCaseToOriginalCase.values();
                }
                return values.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        this.sourceTableViewer.setContentProvider((IContentProvider)contentProvider);
        final ValueLabelProvider valueLabelProvider = new ValueLabelProvider(this.getPart(), this.memberProperty);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return valueLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return valueLabelProvider.getImage(element);
            }

            public void dispose() {
                super.dispose();
                valueLabelProvider.dispose();
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        SwtUtil.makeTableSortable(this.sourceTableViewer);
        SwtUtil.suppressDashedTableEntryBorder(this.sourceTable);
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                SlushBucketPropertyEditor.this.handleSourceTableDoubleClickEvent(event);
            }
        });
        this.sourceTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                SlushBucketPropertyEditor.this.handleSourceTableFocusGainedEvent();
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == ' ') {
                    SlushBucketPropertyEditor.this.handleSourceTableEnterKeyPressEvent();
                }
            }
        });
        this.possibleValuesServiceListener = new Listener(){

            public void handle(Event event) {
                SlushBucketPropertyEditor.this.sourceTableViewer.refresh();
            }
        };
        this.possibleValuesService.attach(this.possibleValuesServiceListener);
        this.sourceTableViewer.setInput(new Object());
        this.addOnDisposeOperation(new Runnable(){

            public void run() {
                if (SlushBucketPropertyEditor.this.possibleValuesService != null) {
                    SlushBucketPropertyEditor.this.possibleValuesService.detach(SlushBucketPropertyEditor.this.possibleValuesServiceListener);
                }
            }
        });
        return composite;
    }

    public SapphireActionHandler createMoveRightActionHandler() {
        this.moveRightActionHandler = new MoveRightActionHandler();
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<String> input = new ArrayList<String>();
                Iterator itr = ((IStructuredSelection)event.getSelection()).iterator();
                while (itr.hasNext()) {
                    input.add((String)itr.next());
                }
                SlushBucketPropertyEditor.this.moveRightActionHandler.setInput(input);
            }
        };
        this.sourceTableViewer.addSelectionChangedListener(listener);
        return this.moveRightActionHandler;
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.sourceTableViewer.refresh();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.sourceTableViewer.refresh();
    }

    protected void handleTableFocusGainedEvent() {
        super.handleTableFocusGainedEvent();
        this.sourceTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void handleSourceTableDoubleClickEvent(MouseEvent event) {
        String doubleClickedItem = null;
        TableItem[] tableItemArray = this.sourceTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                doubleClickedItem = (String)item.getData();
                break;
            }
            ++n2;
        }
        if (doubleClickedItem != null) {
            this.moveRightActionHandler.setInput(Collections.singleton(doubleClickedItem));
            this.moveRightActionHandler.execute(this.getUiContext());
        }
    }

    private void handleSourceTableFocusGainedEvent() {
        this.setSelection(Collections.<IModelElement>emptyList());
        if (this.sourceTableViewer.getSelection().isEmpty() && this.sourceTable.getItemCount() > 0) {
            String firstItem = (String)this.sourceTable.getItem(0).getData();
            this.sourceTableViewer.setSelection((ISelection)new StructuredSelection((Object)firstItem));
        }
    }

    private void handleSourceTableEnterKeyPressEvent() {
        if (!this.sourceTableViewer.getSelection().isEmpty()) {
            this.moveRightActionHandler.execute(this.getUiContext());
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorPart) {
            ModelProperty memberProperty;
            ModelElementType memberType;
            List properties;
            ListProperty listProperty;
            IModelElement element;
            ModelProperty property = propertyEditorPart.getProperty();
            return property instanceof ListProperty && ((PossibleTypesService)(element = propertyEditorPart.getLocalModelElement()).service((ModelProperty)(listProperty = (ListProperty)property), PossibleTypesService.class)).types().size() == 1 && (properties = (memberType = listProperty.getType()).getProperties()).size() == 1 && (memberProperty = (ModelProperty)properties.get(0)) instanceof ValueProperty && memberProperty.hasAnnotation(NoDuplicates.class) && propertyEditorPart.getLocalModelElement().service(memberProperty, PossibleValuesService.class) != null;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new SlushBucketPropertyEditor(context, part);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MoveRightActionHandler
    extends SapphireActionHandler {
        private Collection<String> input = Collections.emptyList();

        private MoveRightActionHandler() {
        }

        @Override
        public void init(SapphireAction action, ISapphireActionHandlerDef def) {
            super.init(action, def);
            this.setEnabled(false);
        }

        public void setInput(Collection<String> input) {
            this.input = input;
            this.setEnabled(SlushBucketPropertyEditor.this.getList() != null && !this.input.isEmpty());
        }

        @Override
        protected Object run(SapphireRenderingContext context) {
            ModelElementList<IModelElement> list = SlushBucketPropertyEditor.this.getList();
            if (list != null) {
                ArrayList<IModelElement> items = new ArrayList<IModelElement>();
                for (String str : this.input) {
                    IModelElement item = list.addNewElement();
                    item.write(SlushBucketPropertyEditor.this.memberProperty, (Object)str);
                    items.add(item);
                }
                SlushBucketPropertyEditor.this.setSelection(items);
                SlushBucketPropertyEditor.this.setFocusOnTable();
            }
            return null;
        }
    }
}

