/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;

public abstract class SapphireHotSpotsActionPresentation
extends SapphireActionPresentation {
    private final Map<SapphireAction, HotSpot> actionToHotSpot = new HashMap<SapphireAction, HotSpot>();
    private Menu popupMenu;

    public SapphireHotSpotsActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    protected final void registerHotSpot(SapphireAction action, HotSpot hotspot) {
        this.actionToHotSpot.put(action, hotspot);
    }

    public final boolean displayActionHandlerChoice(SapphireAction action) {
        HotSpot hotspot = this.actionToHotSpot.get(action);
        if (hotspot == null) {
            return false;
        }
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
            this.popupMenu = null;
        }
        this.popupMenu = new Menu((Decorations)this.getManager().getContext().getShell(), 8);
        for (SapphireActionHandler handler : action.getActiveHandlers()) {
            this.renderMenuItem(this.popupMenu, handler);
        }
        Rectangle bounds = hotspot.getBounds();
        Point pt = new Point(bounds.x, bounds.y + bounds.height);
        this.popupMenu.setLocation(pt);
        this.popupMenu.setVisible(true);
        return true;
    }

    public static class ControlHotSpot
    extends HotSpot {
        private final Control control;

        public ControlHotSpot(Control control) {
            this.control = control;
        }

        public Rectangle getBounds() {
            return this.toDisplay((Control)this.control.getParent(), this.control.getBounds());
        }
    }

    public static abstract class HotSpot {
        public abstract Rectangle getBounds();

        protected Rectangle toDisplay(Control parent, Rectangle bounds) {
            Point location = parent.toDisplay(bounds.x, bounds.y);
            return new Rectangle(location.x, location.y, bounds.width, bounds.height);
        }
    }
}

