/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.RelativePathService;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePathBrowseActionHandler
extends SapphireBrowseActionHandler {
    private static final ImageDescriptor IMG_FILE = SwtRendererUtil.createImageDescriptor(RelativePathBrowseActionHandler.class, "File.png");
    private static final ImageDescriptor IMG_FOLDER = SwtRendererUtil.createImageDescriptor(RelativePathBrowseActionHandler.class, "Folder.png");
    public static final String ID = "Sapphire.Browse.Path.Relative";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_EXTENSIONS = "extensions";
    public static final String PARAM_LEADING_SLASH = "leading-slash";
    private FileExtensionsService fileExtensionService;
    private List<String> staticFileExtensionsList;
    private FileSystemResourceType type;
    private boolean includeLeadingSlash;

    @Override
    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        String paramLeadingSlash;
        super.init(action, def);
        this.setId(ID);
        this.setLabel(Resources.label);
        this.addImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        IModelElement element = this.getModelElement();
        ValueProperty property = this.getProperty();
        this.type = null;
        String paramType = def.getParam(PARAM_TYPE);
        if (paramType != null) {
            if (paramType.equalsIgnoreCase("file")) {
                this.type = FileSystemResourceType.FILE;
            } else if (paramType.equalsIgnoreCase("folder")) {
                this.type = FileSystemResourceType.FOLDER;
            }
        } else {
            ValidFileSystemResourceType validFileSystemResourceTypeAnnotation = (ValidFileSystemResourceType)property.getAnnotation(ValidFileSystemResourceType.class);
            if (validFileSystemResourceTypeAnnotation != null) {
                this.type = validFileSystemResourceTypeAnnotation.value();
            }
        }
        String staticFileExtensions = def.getParam(PARAM_EXTENSIONS);
        if (staticFileExtensions == null) {
            this.fileExtensionService = (FileExtensionsService)element.service((ModelProperty)property, FileExtensionsService.class);
            if (this.fileExtensionService == null) {
                this.staticFileExtensionsList = Collections.emptyList();
            }
        } else {
            this.staticFileExtensionsList = new ArrayList<String>();
            String[] stringArray = staticFileExtensions.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if ((extension = extension.trim()).length() > 0) {
                    this.staticFileExtensionsList.add(extension);
                }
                ++n2;
            }
        }
        this.includeLeadingSlash = (paramLeadingSlash = def.getParam(PARAM_LEADING_SLASH)) != null ? Boolean.parseBoolean(paramLeadingSlash) : false;
    }

    @Override
    protected String browse(SapphireRenderingContext context) {
        Path relativePath;
        Value value;
        DirectoryDialog dialog;
        ValueProperty property = this.getProperty();
        List<Path> roots = this.getBasePaths();
        String selectedAbsolutePath = null;
        List extensions = this.fileExtensionService == null ? this.staticFileExtensionsList : this.fileExtensionService.extensions();
        if (this.enclosed()) {
            Object input;
            ViewerComparator viewerComparator;
            Object labelProvider;
            Object contentProvider;
            ArrayList<IContainer> baseContainers = new ArrayList<IContainer>();
            for (Path path : roots) {
                IContainer baseContainer = RelativePathBrowseActionHandler.getWorkspaceContainer(path.toFile());
                if (baseContainer == null) break;
                baseContainers.add(baseContainer);
            }
            if (roots.size() == baseContainers.size()) {
                contentProvider = new WorkspaceContentProvider(baseContainers);
                labelProvider = new WorkbenchLabelProvider();
                viewerComparator = new ResourceComparator();
                input = ResourcesPlugin.getWorkspace().getRoot();
            } else {
                contentProvider = new FileSystemContentProvider(roots);
                labelProvider = new FileSystemLabelProvider(context);
                viewerComparator = new FileSystemNodeComparator();
                input = new Object();
            }
            ElementTreeSelectionDialog dialog2 = new ElementTreeSelectionDialog(context.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            dialog2.setTitle(property.getLabel(false, CapitalizationType.TITLE_STYLE, false));
            dialog2.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
            dialog2.setAllowMultiple(false);
            dialog2.setHelpAvailable(false);
            dialog2.setInput(input);
            dialog2.setComparator(viewerComparator);
            Path currentPathAbsolute = this.convertToAbsolute((Path)this.getModelElement().read(property).getContent());
            if (currentPathAbsolute != null) {
                FileSystemNode initialSelection = null;
                if (contentProvider instanceof WorkspaceContentProvider) {
                    IContainer container;
                    IContainer[] containers;
                    IFile file;
                    URI uri = currentPathAbsolute.toFile().toURI();
                    IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile[] files = wsroot.findFilesForLocationURI(uri);
                    if (files.length > 0 && (file = files[0]).exists()) {
                        initialSelection = file;
                    }
                    if (initialSelection == null && (containers = wsroot.findContainersForLocationURI(uri)).length > 0 && (container = containers[0]).exists()) {
                        initialSelection = container;
                    }
                } else {
                    initialSelection = ((FileSystemContentProvider)contentProvider).find(currentPathAbsolute);
                }
                if (initialSelection != null) {
                    dialog2.setInitialSelection((Object)initialSelection);
                }
            }
            if (this.type == FileSystemResourceType.FILE) {
                dialog2.setValidator((ISelectionStatusValidator)new FileSelectionStatusValidator());
            } else if (this.type == FileSystemResourceType.FOLDER) {
                dialog2.addFilter((ViewerFilter)new ContainersOnlyViewerFilter());
            }
            if (!extensions.isEmpty()) {
                dialog2.addFilter((ViewerFilter)new ExtensionBasedViewerFilter(extensions));
            }
            if (dialog2.open() == 0) {
                Object firstResult = dialog2.getFirstResult();
                selectedAbsolutePath = firstResult instanceof IResource ? ((IResource)firstResult).getLocation().toString() : ((FileSystemNode)firstResult).getFile().getPath();
            }
        } else if (this.type == FileSystemResourceType.FOLDER) {
            dialog = new DirectoryDialog(context.getShell());
            dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
            dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
            value = this.getModelElement().read(property);
            Path path = (Path)value.getContent();
            if (path != null) {
                dialog.setFilterPath(path.toOSString());
            } else if (roots.size() > 0) {
                dialog.setFilterPath(roots.get(0).toOSString());
            }
            selectedAbsolutePath = dialog.open();
        } else {
            dialog = new FileDialog(context.getShell());
            dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
            value = this.getModelElement().read(property);
            Path path = (Path)value.getContent();
            if (path != null && path.segmentCount() > 1) {
                dialog.setFilterPath(path.removeLastSegments(1).toOSString());
                dialog.setFileName(path.lastSegment());
            } else if (roots.size() > 0) {
                dialog.setFilterPath(roots.get(0).toOSString());
            }
            if (!extensions.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String extension : extensions) {
                    if (buf.length() > 0) {
                        buf.append(';');
                    }
                    buf.append("*.");
                    buf.append(extension);
                }
                dialog.setFilterExtensions(new String[]{buf.toString()});
            }
            selectedAbsolutePath = dialog.open();
        }
        if (selectedAbsolutePath != null && (relativePath = this.convertToRelative(new Path(selectedAbsolutePath))) != null) {
            String result = relativePath.toPortableString();
            if (this.includeLeadingSlash) {
                result = "/" + result;
            }
            return result;
        }
        return null;
    }

    protected List<Path> getBasePaths() {
        return ((RelativePathService)this.getModelElement().service((ModelProperty)this.getProperty(), RelativePathService.class)).roots();
    }

    protected boolean enclosed() {
        RelativePathService service = (RelativePathService)this.getModelElement().service((ModelProperty)this.getProperty(), RelativePathService.class);
        if (service == null) {
            return true;
        }
        return service.enclosed();
    }

    protected Path convertToRelative(Path path) {
        if (path != null) {
            RelativePathService service = (RelativePathService)this.getModelElement().service((ModelProperty)this.getProperty(), RelativePathService.class);
            if (service == null) {
                if (this.enclosed()) {
                    for (Path root : this.getBasePaths()) {
                        if (!root.isPrefixOf(path)) continue;
                        return path.makeRelativeTo(root);
                    }
                } else {
                    String pathDevice = path.getDevice();
                    for (Path root : this.getBasePaths()) {
                        if (!MiscUtil.equal((Object)pathDevice, (Object)root.getDevice())) continue;
                        return path.makeRelativeTo(root);
                    }
                }
            } else {
                return service.convertToRelative(path);
            }
        }
        return null;
    }

    protected Path convertToAbsolute(Path path) {
        if (path != null) {
            RelativePathService service = (RelativePathService)this.getModelElement().service((ModelProperty)this.getProperty(), RelativePathService.class);
            if (service == null) {
                if (this.enclosed() && path.segmentCount() > 0 && path.segment(0).equals("..")) {
                    return null;
                }
                Path absolute = null;
                for (Path root : this.getBasePaths()) {
                    try {
                        File file = root.append(path).toFile().getCanonicalFile();
                        absolute = new Path(file.getPath());
                        if (!file.exists()) continue;
                        break;
                    }
                    catch (IOException iOException) {}
                }
                return absolute;
            }
            return service.convertToAbsolute(path);
        }
        return null;
    }

    private static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    private static IContainer getWorkspaceContainer(File f) {
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] wsContainers = wsroot.findContainersForLocationURI(f.toURI());
        if (wsContainers.length > 0) {
            return wsContainers[0];
        }
        return null;
    }

    public static final class ContainersOnlyViewerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parent, Object element) {
            return element instanceof IContainer || element instanceof FileSystemNode && ((FileSystemNode)element).getFile().isDirectory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExtensionBasedViewerFilter
    extends ViewerFilter {
        private List<String> extensions;

        public ExtensionBasedViewerFilter(List<String> extensions) {
            this.change(extensions);
        }

        public void change(List<String> extensions) {
            this.extensions = new ArrayList<String>(extensions);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IFile || element instanceof FileSystemNode && ((FileSystemNode)element).getFile().isFile()) {
                String extension = element instanceof IFile ? ((IFile)element).getFileExtension() : RelativePathBrowseActionHandler.getFileExtension(((FileSystemNode)element).getFile().getName());
                if (extension != null && extension.length() != 0) {
                    for (String ext : this.extensions) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (element instanceof IContainer) {
                return !(element instanceof IProject) || ((IProject)element).isOpen();
            }
            return true;
        }
    }

    private static final class FileSelectionStatusValidator
    implements ISelectionStatusValidator {
        private static final IStatus ERROR_STATUS = new Status(4, "org.eclipse.sapphire.ui", "");
        private static final IStatus OK_STATUS = new Status(0, "org.eclipse.sapphire.ui", "");

        private FileSelectionStatusValidator() {
        }

        public IStatus validate(Object[] selection) {
            Object sel;
            if (selection.length == 1 && ((sel = selection[0]) instanceof IFile || sel instanceof FileSystemNode && ((FileSystemNode)sel).getFile().isFile())) {
                return OK_STATUS;
            }
            return ERROR_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileSystemContentProvider
    implements ITreeContentProvider {
        private final FileSystemNode[] roots;

        public FileSystemContentProvider(List<Path> roots) {
            this.roots = new FileSystemNode[roots.size()];
            int i = 0;
            int n = roots.size();
            while (i < n) {
                this.roots[i] = new FileSystemNode(roots.get(i).toFile(), null);
                ++i;
            }
        }

        public FileSystemNode find(Path path) {
            FileSystemNode[] fileSystemNodeArray = this.roots;
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                FileSystemNode root = fileSystemNodeArray[n2];
                Path rootPath = new Path(root.getFile().getPath());
                if (rootPath.isPrefixOf(path)) {
                    return root.find(path.makeRelativeTo(rootPath));
                }
                ++n2;
            }
            return null;
        }

        public Object[] getElements(Object element) {
            return this.roots;
        }

        public Object getParent(Object element) {
            return ((FileSystemNode)element).getParent();
        }

        public Object[] getChildren(Object element) {
            return ((FileSystemNode)element).getChildren();
        }

        public boolean hasChildren(Object element) {
            return ((FileSystemNode)element).hasChildren();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class FileSystemLabelProvider
    extends LabelProvider {
        private final SapphireRenderingContext context;

        public FileSystemLabelProvider(SapphireRenderingContext context) {
            this.context = context;
        }

        public String getText(Object element) {
            return ((FileSystemNode)element).getFile().getName();
        }

        public Image getImage(Object element) {
            if (((FileSystemNode)element).getFile().isDirectory()) {
                return this.context.getImageCache().getImage(IMG_FOLDER);
            }
            return this.context.getImageCache().getImage(IMG_FILE);
        }
    }

    private static final class FileSystemNode {
        private final File file;
        private final FileSystemNode parent;
        private Map<File, FileSystemNode> children;

        public FileSystemNode(File file, FileSystemNode parent) {
            this.file = file;
            this.parent = parent;
            this.children = Collections.emptyMap();
        }

        public File getFile() {
            return this.file;
        }

        public FileSystemNode getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return this.file.isDirectory();
        }

        public FileSystemNode[] getChildren() {
            File[] directoryListing;
            if (this.file.isDirectory() && (directoryListing = this.file.listFiles()) != null && directoryListing.length > 0) {
                FileSystemNode[] result = new FileSystemNode[directoryListing.length];
                HashMap<File, FileSystemNode> newChildrenMap = new HashMap<File, FileSystemNode>();
                int i = 0;
                int n = directoryListing.length;
                while (i < n) {
                    File f = directoryListing[i];
                    FileSystemNode node = this.children.get(f);
                    if (node == null) {
                        node = new FileSystemNode(f, this);
                    }
                    newChildrenMap.put(f, node);
                    result[i] = node;
                    ++i;
                }
                this.children = newChildrenMap;
                return result;
            }
            return new FileSystemNode[0];
        }

        public FileSystemNode find(Path path) {
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount == 0) {
                return this;
            }
            String firstSegment = path.segment(0);
            FileSystemNode[] fileSystemNodeArray = this.getChildren();
            int n = fileSystemNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileSystemNode child = fileSystemNodeArray[n2];
                if (child.getFile().getName().equals(firstSegment)) {
                    return child.find(path.removeFirstSegments(1));
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class FileSystemNodeComparator
    extends ViewerComparator {
        private FileSystemNodeComparator() {
        }

        public int compare(Viewer viewer, Object obj1, Object obj2) {
            boolean isFile2Directory;
            File f1 = ((FileSystemNode)obj1).getFile();
            File f2 = ((FileSystemNode)obj2).getFile();
            boolean isFile1Directory = f1.isDirectory();
            if (isFile1Directory == (isFile2Directory = f2.isDirectory())) {
                return Policy.getComparator().compare(f1.getName(), f2.getName());
            }
            if (isFile1Directory) {
                return -1;
            }
            return 1;
        }
    }

    public static final class ResourceComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object obj1, Object obj2) {
            IResource r1 = (IResource)obj1;
            boolean isResource1Container = r1 instanceof IContainer;
            IResource r2 = (IResource)obj2;
            boolean isResource2Container = r2 instanceof IContainer;
            if (isResource1Container == isResource2Container) {
                return Policy.getComparator().compare(r1.getName(), r2.getName());
            }
            if (isResource1Container) {
                return -1;
            }
            return 1;
        }
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)RelativePathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WorkspaceContentProvider
    extends WorkbenchContentProvider {
        private final List<IContainer> roots;

        public WorkspaceContentProvider(List<IContainer> roots) {
            this.roots = roots;
        }

        public Object[] getElements(Object element) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (this.roots.size() == 1) {
                IContainer root = this.roots.get(0);
                try {
                    IResource[] iResourceArray = root.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if (child.isAccessible()) {
                            elements.add(child);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            } else {
                elements.addAll(this.roots);
            }
            return elements.toArray(new IResource[elements.size()]);
        }

        public Object getParent(Object element) {
            if (this.roots.contains(element) || this.roots.size() == 1 && this.roots.contains(((IResource)element).getParent())) {
                return null;
            }
            return super.getParent(element);
        }
    }
}

