/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlUtil {
    public static final String EMPTY_STRING = "";
    public static final String PI_XML_TARGET = "xml";
    public static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";

    public static void changeNamespace(Document document, String oldNamespace, String newNamespace, String newSchemaLocation) {
        Element oldRootElement = document.getDocumentElement();
        if (oldRootElement != null) {
            Node nodeAfterRootElement = oldRootElement.getNextSibling();
            Node newRootElement = XmlUtil.changeNamespace(oldRootElement, oldNamespace, newNamespace, newSchemaLocation);
            document.removeChild(oldRootElement);
            document.insertBefore(newRootElement, nodeAfterRootElement);
        }
    }

    private static Node changeNamespace(Node node, String oldNamespace, String newNamespace, String newSchemaLocation) {
        if (node instanceof Element) {
            String elementNameSpaceUri = node.getNamespaceURI();
            String elementQualifiedName = node.getNodeName();
            String nameSpaceDeclarationAttr = null;
            if (elementNameSpaceUri != null && elementNameSpaceUri.equals(oldNamespace)) {
                elementNameSpaceUri = newNamespace;
                String prefix = node.getPrefix();
                nameSpaceDeclarationAttr = prefix == null ? XMLNS : XMLNS_COLON + prefix;
            }
            Document document = node.getOwnerDocument();
            Element newElement = document.createElementNS(elementNameSpaceUri, elementQualifiedName);
            NodeList children = node.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node oldChildNode = children.item(i);
                Node newChildNode = XmlUtil.changeNamespace(oldChildNode, oldNamespace, newNamespace, newSchemaLocation);
                newElement.appendChild(newChildNode);
                ++i;
            }
            NamedNodeMap attributes = node.getAttributes();
            boolean updatedNamespace = false;
            boolean updatedSchemaLocation = false;
            int i2 = 0;
            int n2 = attributes.getLength();
            while (i2 < n2) {
                Attr attr = (Attr)attributes.item(i2);
                String attrNameSpaceUri = attr.getNamespaceURI();
                String attrQualifiedName = attr.getNodeName();
                String attrValue = attr.getValue();
                if (attrQualifiedName.equals(nameSpaceDeclarationAttr)) {
                    attrValue = newNamespace;
                    updatedNamespace = true;
                } else if (attr.getLocalName() != null && attr.getLocalName().equals("schemaLocation")) {
                    attrValue = XmlUtil.createSchemaLocationAttrValue(newSchemaLocation);
                    updatedSchemaLocation = true;
                }
                newElement.setAttributeNS(attrNameSpaceUri, attrQualifiedName, attrValue);
                ++i2;
            }
            if (updatedNamespace && !updatedSchemaLocation) {
                XmlUtil.configSchemaLocation(newElement, newSchemaLocation);
            }
            return newElement;
        }
        return node.cloneNode(true);
    }

    public static void configSchemaLocation(Element element, String primarySchemaLocation) {
        String schemaLocationAttrValue = XmlUtil.createSchemaLocationAttrValue(primarySchemaLocation);
        element.setAttributeNS(null, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocationAttrValue);
    }

    private static String createSchemaLocationAttrValue(String primarySchemaLocation) {
        XmlDocumentSchema xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(primarySchemaLocation);
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : xmlDocumentSchema.getSchemaLocations().entrySet()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(entry.getKey());
            buf.append(' ');
            buf.append(entry.getValue());
        }
        return buf.toString();
    }

    public static QName createQualifiedName(String name, XmlNamespaceResolver xmlNamespaceResolver) {
        QName qname = xmlNamespaceResolver == null ? new QName(null, name, EMPTY_STRING) : xmlNamespaceResolver.createQualifiedName(name);
        return qname;
    }

    public static QName createQualifiedName(Node node) {
        String namespace = node.getNamespaceURI();
        String localName = node.getLocalName();
        return new QName(namespace, localName);
    }

    public static QName createDefaultElementName(ModelElementType type) {
        XmlPath.Segment firstSegment;
        XmlPath path;
        QName name = null;
        XmlBinding xmlBindingAnnotation = (XmlBinding)type.getAnnotation(XmlBinding.class);
        StandardXmlNamespaceResolver xmlNamespaceResolver = new StandardXmlNamespaceResolver(type);
        if (xmlBindingAnnotation != null && (path = new XmlPath(xmlBindingAnnotation.path(), xmlNamespaceResolver)).getSegmentCount() == 1 && !(firstSegment = path.getSegment(0)).isAttribute() && !firstSegment.isComment()) {
            name = firstSegment.getQualifiedName();
        }
        if (name == null) {
            String xmlElementName = type.getSimpleName();
            if (xmlElementName.charAt(0) == 'I' && xmlElementName.length() > 1 && Character.isUpperCase(xmlElementName.charAt(1))) {
                xmlElementName = xmlElementName.substring(1);
            }
            name = XmlUtil.createQualifiedName(xmlElementName, xmlNamespaceResolver);
        }
        return name;
    }

    public static boolean equal(QName a, QName b, String defaultNamespace) {
        if (a.getLocalPart().equals(b.getLocalPart())) {
            String nsa = a.getNamespaceURI();
            String nsb = b.getNamespaceURI();
            if (nsa == null || nsa.length() == 0) {
                nsa = defaultNamespace;
            }
            if (nsb == null || nsb.length() == 0) {
                nsb = defaultNamespace;
            }
            return nsa.equals(nsb);
        }
        return false;
    }

    public static boolean contains(QName[] qnames, QName qname, String defaultNamespace) {
        QName[] qNameArray = qnames;
        int n = qnames.length;
        int n2 = 0;
        while (n2 < n) {
            QName a = qNameArray[n2];
            if (XmlUtil.equal(a, qname, defaultNamespace)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

