/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.platform;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Status;

public final class StatusBridge {
    private StatusBridge() {
    }

    public static IStatus create(final Status status) {
        int severity;
        List childrenOriginal = status.children();
        final IStatus[] childrenBridged = new IStatus[childrenOriginal.size()];
        int i = 0;
        while (i < childrenBridged.length) {
            childrenBridged[i] = StatusBridge.create((Status)childrenOriginal.get(i));
            ++i;
        }
        switch (status.severity()) {
            case ERROR: {
                severity = 4;
                break;
            }
            case WARNING: {
                severity = 2;
                break;
            }
            case INFO: {
                severity = 1;
                break;
            }
            default: {
                severity = 0;
            }
        }
        return new IStatus(){

            public IStatus[] getChildren() {
                return childrenBridged;
            }

            public int getCode() {
                return 0;
            }

            public Throwable getException() {
                return status.exception();
            }

            public String getMessage() {
                return status.message();
            }

            public String getPlugin() {
                return "org.eclipse.sapphire.osgi";
            }

            public int getSeverity() {
                return severity;
            }

            public boolean isMultiStatus() {
                return !status.children().isEmpty();
            }

            public boolean isOK() {
                return status.severity() == Status.Severity.OK;
            }

            public boolean matches(int severityMask) {
                return (this.getSeverity() & severityMask) != 0;
            }
        };
    }

    public static Status create(IStatus status) {
        if (status.isMultiStatus()) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus st = iStatusArray[n2];
                factory.merge(StatusBridge.create(st));
                ++n2;
            }
            return factory.create();
        }
        Status.LeafStatusFactory factory = Status.factoryForLeaf();
        factory.message(status.getMessage());
        switch (status.getSeverity()) {
            case 4: {
                factory.severity(Status.Severity.ERROR);
                break;
            }
            case 2: {
                factory.severity(Status.Severity.WARNING);
                break;
            }
            case 1: {
                factory.severity(Status.Severity.INFO);
                break;
            }
            default: {
                factory.severity(Status.Severity.OK);
            }
        }
        factory.exception(status.getException());
        factory.type("Sapphire.Bridged." + status.getPlugin() + "." + status.getCode());
        return factory.create();
    }
}

