/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.address.Address;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddressImpl
extends ModelElement
implements Address {
    private Value<String> pCity;
    private Value<String> pState;
    private Value<String> pStreet;
    private Value<String> pZipCode;

    public AddressImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public AddressImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCity() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pCity == null) {
                this.refresh((ModelProperty)PROP_CITY, true);
            }
            return this.pCity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCity(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CITY.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_CITY, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_CITY, true);
            if (!AddressImpl.equal((String)this.pCity.getText(false), (String)value)) {
                this.resource().binding(PROP_CITY).write(value);
                this.refresh((ModelProperty)PROP_CITY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getState() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pState == null) {
                this.refresh((ModelProperty)PROP_STATE, true);
            }
            return this.pState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STATE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STATE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STATE, true);
            if (!AddressImpl.equal((String)this.pState.getText(false), (String)value)) {
                this.resource().binding(PROP_STATE).write(value);
                this.refresh((ModelProperty)PROP_STATE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStreet() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pStreet == null) {
                this.refresh((ModelProperty)PROP_STREET, true);
            }
            return this.pStreet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreet(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STREET.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STREET, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STREET, true);
            if (!AddressImpl.equal((String)this.pStreet.getText(false), (String)value)) {
                this.resource().binding(PROP_STREET).write(value);
                this.refresh((ModelProperty)PROP_STREET, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getZipCode() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pZipCode == null) {
                this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            }
            return this.pZipCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZipCode(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ZIP_CODE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ZIP_CODE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            if (!AddressImpl.equal((String)this.pZipCode.getText(false), (String)value)) {
                this.resource().binding(PROP_ZIP_CODE).write(value);
                this.refresh((ModelProperty)PROP_ZIP_CODE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CITY) {
                if (this.pCity != null || force) {
                    Value<String> oldValue = this.pCity;
                    String val = this.resource().binding(PROP_CITY).read();
                    this.pCity = new Value((IModelElement)this, PROP_CITY, ((ValueNormalizationService)this.service((ModelProperty)PROP_CITY, ValueNormalizationService.class)).normalize(PROP_CITY.encodeKeywords(val)));
                    this.pCity.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_CITY);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_CITY));
                    } else {
                        if (this.pCity.equals(oldValue)) {
                            this.pCity = oldValue;
                        } else {
                            if (!AddressImpl.equal((String)this.pCity.getText(false), (String)oldValue.getText(false)) || !AddressImpl.equal((String)this.pCity.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_CITY));
                            }
                            if (!this.pCity.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_CITY, oldValue.validation(), this.pCity.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_CITY, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_STATE) {
                if (this.pState != null || force) {
                    Value<String> oldValue = this.pState;
                    String val = this.resource().binding(PROP_STATE).read();
                    this.pState = new Value((IModelElement)this, PROP_STATE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STATE, ValueNormalizationService.class)).normalize(PROP_STATE.encodeKeywords(val)));
                    this.pState.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STATE);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STATE));
                    } else {
                        if (this.pState.equals(oldValue)) {
                            this.pState = oldValue;
                        } else {
                            if (!AddressImpl.equal((String)this.pState.getText(false), (String)oldValue.getText(false)) || !AddressImpl.equal((String)this.pState.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STATE));
                            }
                            if (!this.pState.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STATE, oldValue.validation(), this.pState.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STATE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_STREET) {
                if (this.pStreet != null || force) {
                    Value<String> oldValue = this.pStreet;
                    String val = this.resource().binding(PROP_STREET).read();
                    this.pStreet = new Value((IModelElement)this, PROP_STREET, ((ValueNormalizationService)this.service((ModelProperty)PROP_STREET, ValueNormalizationService.class)).normalize(PROP_STREET.encodeKeywords(val)));
                    this.pStreet.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STREET);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STREET));
                    } else {
                        if (this.pStreet.equals(oldValue)) {
                            this.pStreet = oldValue;
                        } else {
                            if (!AddressImpl.equal((String)this.pStreet.getText(false), (String)oldValue.getText(false)) || !AddressImpl.equal((String)this.pStreet.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STREET));
                            }
                            if (!this.pStreet.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STREET, oldValue.validation(), this.pStreet.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STREET, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_ZIP_CODE && (this.pZipCode != null || force)) {
                Value<String> oldValue = this.pZipCode;
                String val = this.resource().binding(PROP_ZIP_CODE).read();
                this.pZipCode = new Value((IModelElement)this, PROP_ZIP_CODE, ((ValueNormalizationService)this.service((ModelProperty)PROP_ZIP_CODE, ValueNormalizationService.class)).normalize(PROP_ZIP_CODE.encodeKeywords(val)));
                this.pZipCode.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ZIP_CODE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ZIP_CODE));
                } else {
                    if (this.pZipCode.equals(oldValue)) {
                        this.pZipCode = oldValue;
                    } else {
                        if (!AddressImpl.equal((String)this.pZipCode.getText(false), (String)oldValue.getText(false)) || !AddressImpl.equal((String)this.pZipCode.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ZIP_CODE));
                        }
                        if (!this.pZipCode.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ZIP_CODE, oldValue.validation(), this.pZipCode.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ZIP_CODE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_CITY) {
            return this.getCity();
        }
        if (property == PROP_STATE) {
            return this.getState();
        }
        if (property == PROP_STREET) {
            return this.getStreet();
        }
        if (property == PROP_ZIP_CODE) {
            return this.getZipCode();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CITY) {
            this.setCity((String)value);
            return;
        }
        if (property == PROP_STATE) {
            this.setState((String)value);
            return;
        }
        if (property == PROP_STREET) {
            this.setStreet((String)value);
            return;
        }
        if (property == PROP_ZIP_CODE) {
            this.setZipCode((String)value);
            return;
        }
        super.write(property, value);
    }
}

