/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactsDatabase;
import org.eclipse.sapphire.services.ImageService;
import org.eclipse.sapphire.services.ImageServiceData;

public final class ContactDatabaseImageService
extends ImageService {
    private static final ImageServiceData IMG_PERSON = new ImageServiceData(ImageData.readFromClassLoader(Contact.class, (String)"Contact.png"));
    private static final ImageServiceData IMG_PERSON_FADED = new ImageServiceData(ImageData.readFromClassLoader(Contact.class, (String)"ContactFaded.png"));
    private Listener listener;

    protected void initImageService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ContactDatabaseImageService.this.refresh();
            }
        };
        ((IModelElement)this.context(IModelElement.class)).attach(this.listener, "Contacts/EMail");
    }

    protected ImageServiceData compute() {
        boolean foundContactWithEMail = false;
        for (Contact contact : ((ContactsDatabase)this.context(ContactsDatabase.class)).getContacts()) {
            if (contact.getEMail().getContent() == null) continue;
            foundContactWithEMail = true;
            break;
        }
        return foundContactWithEMail ? IMG_PERSON : IMG_PERSON_FADED;
    }

    public void dispose() {
        super.dispose();
        ((IModelElement)this.context(IModelElement.class)).detach(this.listener, "Contacts/EMail");
    }
}

