/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.gallery.IListItemWithJavaType;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListItemWithJavaType
extends ModelElement
implements IListItemWithJavaType {
    private ReferenceValue<JavaTypeName, JavaType> pJavaType;

    public ListItemWithJavaType(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ListItemWithJavaType(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<JavaTypeName, JavaType> getJavaType() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pJavaType == null) {
                this.refresh((ModelProperty)PROP_JAVA_TYPE, true);
            }
            return this.pJavaType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJavaType(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_JAVA_TYPE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_JAVA_TYPE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_JAVA_TYPE, true);
            if (!ListItemWithJavaType.equal((String)this.pJavaType.getText(false), (String)value)) {
                this.resource().binding(PROP_JAVA_TYPE).write(value);
                this.refresh((ModelProperty)PROP_JAVA_TYPE, false);
            }
        }
    }

    @Override
    public void setJavaType(JavaTypeName value) {
        this.setJavaType(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_JAVA_TYPE, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_JAVA_TYPE && (this.pJavaType != null || force)) {
                ReferenceValue<JavaTypeName, JavaType> oldValue = this.pJavaType;
                String val = this.resource().binding(PROP_JAVA_TYPE).read();
                this.pJavaType = new ReferenceValue((IModelElement)this, PROP_JAVA_TYPE, ((ValueNormalizationService)this.service((ModelProperty)PROP_JAVA_TYPE, ValueNormalizationService.class)).normalize(PROP_JAVA_TYPE.encodeKeywords(val)));
                this.pJavaType.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_JAVA_TYPE);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_JAVA_TYPE));
                } else {
                    if (this.pJavaType.equals(oldValue)) {
                        this.pJavaType = oldValue;
                    } else {
                        if (!ListItemWithJavaType.equal((String)this.pJavaType.getText(false), (String)oldValue.getText(false)) || !ListItemWithJavaType.equal((String)this.pJavaType.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_JAVA_TYPE));
                        }
                        if (!this.pJavaType.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_JAVA_TYPE, oldValue.validation(), this.pJavaType.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_JAVA_TYPE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_JAVA_TYPE) {
            return this.getJavaType();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_JAVA_TYPE) {
            if (!(value instanceof String)) {
                this.setJavaType((JavaTypeName)value);
            } else {
                this.setJavaType((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

