/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el;

import java.math.BigInteger;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class FactorialFunction
extends Function {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    public String name() {
        return "test:factorial";
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                BigInteger x = (BigInteger)this.cast(this.operand(0).value(), BigInteger.class);
                if (x.intValue() == 0) {
                    return BigInteger.valueOf(1L);
                }
                BigInteger res = x;
                BigInteger i = x.subtract(ONE);
                while (i.compareTo(ZERO) > 0) {
                    res = res.multiply(i);
                    i = i.subtract(ONE);
                }
                return res;
            }
        };
    }
}

