/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.tests.modeling.el.TestElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestElementImpl
extends ModelElement
implements TestElement {
    private ModelElementHandle<TestElement> pFooBar;
    private Value<Integer> pIntegerProp;
    private Value<String> pStringProp;

    public TestElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<TestElement> getFooBar() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pFooBar == null) {
                this.refresh((ModelProperty)PROP_FOO_BAR, true);
            }
            return this.pFooBar;
        }
    }

    protected void disposeProperties() {
        IModelElement element;
        if (this.pFooBar != null && (element = this.pFooBar.element(false)) != null) {
            element.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getIntegerProp() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pIntegerProp == null) {
                this.refresh((ModelProperty)PROP_INTEGER_PROP, true);
            }
            return this.pIntegerProp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIntegerProp(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_INTEGER_PROP.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_PROP, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_INTEGER_PROP, true);
            if (!TestElementImpl.equal((String)this.pIntegerProp.getText(false), (String)value)) {
                this.resource().binding(PROP_INTEGER_PROP).write(value);
                this.refresh((ModelProperty)PROP_INTEGER_PROP, false);
            }
        }
    }

    @Override
    public void setIntegerProp(Integer value) {
        this.setIntegerProp(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_INTEGER_PROP, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringProp() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pStringProp == null) {
                this.refresh((ModelProperty)PROP_STRING_PROP, true);
            }
            return this.pStringProp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringProp(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_PROP.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_PROP, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_PROP, true);
            if (!TestElementImpl.equal((String)this.pStringProp.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_PROP).write(value);
                this.refresh((ModelProperty)PROP_STRING_PROP, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_FOO_BAR) {
                if (this.pFooBar == null) {
                    if (force) {
                        this.pFooBar = new ModelElementHandle((IModelElement)this, PROP_FOO_BAR);
                        this.pFooBar.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_FOO_BAR);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_FOO_BAR));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_FOO_BAR);
                    boolean notified = this.pFooBar.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_FOO_BAR, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_INTEGER_PROP) {
                if (this.pIntegerProp != null || force) {
                    Value<Integer> oldValue = this.pIntegerProp;
                    String val = this.resource().binding(PROP_INTEGER_PROP).read();
                    this.pIntegerProp = new Value((IModelElement)this, PROP_INTEGER_PROP, ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_PROP, ValueNormalizationService.class)).normalize(PROP_INTEGER_PROP.encodeKeywords(val)));
                    this.pIntegerProp.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_INTEGER_PROP);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_PROP));
                    } else {
                        if (this.pIntegerProp.equals(oldValue)) {
                            this.pIntegerProp = oldValue;
                        } else {
                            if (!TestElementImpl.equal((String)this.pIntegerProp.getText(false), (String)oldValue.getText(false)) || !TestElementImpl.equal((String)this.pIntegerProp.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_PROP));
                            }
                            if (!this.pIntegerProp.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_PROP, oldValue.validation(), this.pIntegerProp.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_INTEGER_PROP, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_STRING_PROP && (this.pStringProp != null || force)) {
                Value<String> oldValue = this.pStringProp;
                String val = this.resource().binding(PROP_STRING_PROP).read();
                this.pStringProp = new Value((IModelElement)this, PROP_STRING_PROP, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_PROP, ValueNormalizationService.class)).normalize(PROP_STRING_PROP.encodeKeywords(val)));
                this.pStringProp.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_PROP);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_STRING_PROP));
                } else {
                    if (this.pStringProp.equals(oldValue)) {
                        this.pStringProp = oldValue;
                    } else {
                        if (!TestElementImpl.equal((String)this.pStringProp.getText(false), (String)oldValue.getText(false)) || !TestElementImpl.equal((String)this.pStringProp.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_STRING_PROP));
                        }
                        if (!this.pStringProp.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_STRING_PROP, oldValue.validation(), this.pStringProp.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_STRING_PROP, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_FOO_BAR) {
            return this.getFooBar();
        }
        if (property == PROP_INTEGER_PROP) {
            return this.getIntegerProp();
        }
        if (property == PROP_STRING_PROP) {
            return this.getStringProp();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_INTEGER_PROP) {
            if (!(value instanceof String)) {
                this.setIntegerProp((Integer)value);
            } else {
                this.setIntegerProp((String)value);
            }
            return;
        }
        if (property == PROP_STRING_PROP) {
            this.setStringProp((String)value);
            return;
        }
        super.write(property, value);
    }
}

