/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0001;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.EventLog;
import org.eclipse.sapphire.tests.modeling.events.t0001.GlobalRequiredStringValueEventLog;
import org.eclipse.sapphire.tests.modeling.events.t0001.GlobalRootElementEventLog;
import org.eclipse.sapphire.tests.modeling.events.t0001.RootElement;

public final class TestModelingEvents0001
extends SapphireTestCase {
    private TestModelingEvents0001(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingEvents0001");
        suite.addTest((Test)new TestModelingEvents0001("testElementListenerInstance"));
        suite.addTest((Test)new TestModelingEvents0001("testElementListenerGlobal"));
        suite.addTest((Test)new TestModelingEvents0001("testPropertyListenerInstance"));
        suite.addTest((Test)new TestModelingEvents0001("testPropertyListenerGlobal"));
        return suite;
    }

    public void testElementListenerInstance() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        EventLog log = new EventLog();
        root.attach(log);
        this.testElementListener(root, log);
    }

    public void testElementListenerGlobal() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        this.testElementListener(root, GlobalRootElementEventLog.INSTANCE);
    }

    public void testPropertyListenerInstance() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        EventLog log = new EventLog();
        root.attach(log, RootElement.PROP_REQUIRED_STRING_VALUE.getName());
        this.testPropertyListener(root, log);
    }

    public void testPropertyListenerGlobal() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        this.testPropertyListener(root, GlobalRequiredStringValueEventLog.INSTANCE);
    }

    private void testElementListener(RootElement root, EventLog log) throws Exception {
        log.clear();
        Status initialPropertyValidation = root.getRequiredStringValue().validation();
        Status initialElementValidation = root.validation();
        TestModelingEvents0001.assertValidationError(initialPropertyValidation, "Required string value must be specified.");
        TestModelingEvents0001.assertValidationError(initialElementValidation, "Required string value must be specified.");
        TestModelingEvents0001.assertEquals((int)2, (int)log.size());
        TestModelingEvents0001.assertPropertyInitializationEvent(log.event(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0001.assertPropertyInitializationEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        log.clear();
        root.setRequiredStringValue("abc");
        TestModelingEvents0001.assertEquals((int)3, (int)log.size());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        TestModelingEvents0001.assertPropertyValidationEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, initialPropertyValidation, Status.createOkStatus());
        TestModelingEvents0001.assertElementValidationEvent(log.event(2), root, initialPropertyValidation, Status.createOkStatus());
        root.setRequiredStringValue(null);
        log.clear();
        root.setRequiredStringValue("abc");
        root.setRequiredStringValue("xyz");
        TestModelingEvents0001.assertEquals((int)4, (int)log.size());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        TestModelingEvents0001.assertPropertyValidationEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, initialPropertyValidation, Status.createOkStatus());
        TestModelingEvents0001.assertElementValidationEvent(log.event(2), root, initialPropertyValidation, Status.createOkStatus());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(3), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        log.clear();
        root.setEnablement(false);
        root.setEnablement(true);
        TestModelingEvents0001.assertEquals((int)4, (int)log.size());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0001.assertPropertyEnablementEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, true, false);
        TestModelingEvents0001.assertPropertyContentEvent(log.event(2), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0001.assertPropertyEnablementEvent(log.event(3), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, false, true);
        log.clear();
        root.dispose();
        TestModelingEvents0001.assertEquals((int)1, (int)log.size());
        TestModelingEvents0001.assertElementDisposeEvent(log.event(0), root);
    }

    private void testPropertyListener(RootElement root, EventLog log) throws Exception {
        log.clear();
        Status initialPropertyValidation = root.getRequiredStringValue().validation();
        Status initialElementValidation = root.validation();
        TestModelingEvents0001.assertValidationError(initialPropertyValidation, "Required string value must be specified.");
        TestModelingEvents0001.assertValidationError(initialElementValidation, "Required string value must be specified.");
        TestModelingEvents0001.assertEquals((int)1, (int)log.size());
        TestModelingEvents0001.assertPropertyInitializationEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        log.clear();
        root.setRequiredStringValue("abc");
        TestModelingEvents0001.assertEquals((int)2, (int)log.size());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        TestModelingEvents0001.assertPropertyValidationEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, initialPropertyValidation, Status.createOkStatus());
        root.setRequiredStringValue(null);
        log.clear();
        root.setRequiredStringValue("abc");
        root.setRequiredStringValue("xyz");
        TestModelingEvents0001.assertEquals((int)3, (int)log.size());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        TestModelingEvents0001.assertPropertyValidationEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, initialPropertyValidation, Status.createOkStatus());
        TestModelingEvents0001.assertPropertyContentEvent(log.event(2), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE);
        log.clear();
        root.setEnablement(false);
        root.setEnablement(true);
        TestModelingEvents0001.assertEquals((int)2, (int)log.size());
        TestModelingEvents0001.assertPropertyEnablementEvent(log.event(0), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, true, false);
        TestModelingEvents0001.assertPropertyEnablementEvent(log.event(1), root, (ModelProperty)RootElement.PROP_REQUIRED_STRING_VALUE, false, true);
        log.clear();
        root.dispose();
        TestModelingEvents0001.assertEquals((int)0, (int)log.size());
    }
}

