/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0002;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.t0002.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0002.RootElement;

public final class TestModelingEvents0002
extends SapphireTestCase {
    private TestModelingEvents0002(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingEvents0002");
        suite.addTest((Test)new TestModelingEvents0002("testListPropertyEvents"));
        return suite;
    }

    public void testListPropertyEvents() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        final ArrayList events = new ArrayList();
        Listener listener = new Listener(){

            public void handle(Event event) {
                events.add(event);
            }
        };
        root.attach(listener);
        Status initialPropertyValidation = root.getChildren().validation();
        Status initialElementValidation = root.validation();
        TestModelingEvents0002.assertValidationError(initialPropertyValidation, "At least one child element must be specified.");
        TestModelingEvents0002.assertValidationError(initialElementValidation, "At least one child element must be specified.");
        TestModelingEvents0002.assertEquals((int)2, (int)events.size());
        TestModelingEvents0002.assertPropertyInitializationEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0002.assertPropertyInitializationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILDREN);
        events.clear();
        ChildElement child = (ChildElement)root.getChildren().insert();
        child.attach(listener);
        TestModelingEvents0002.assertEquals((int)3, (int)events.size());
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_CHILDREN);
        TestModelingEvents0002.assertPropertyValidationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILDREN, initialPropertyValidation, Status.createOkStatus());
        TestModelingEvents0002.assertElementValidationEvent((Event)events.get(2), root, initialElementValidation, Status.createOkStatus());
        events.clear();
        child.setIntegerValue("abc");
        TestModelingEvents0002.assertEquals((int)5, (int)events.size());
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(0), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE);
        TestModelingEvents0002.assertPropertyValidationEvent((Event)events.get(1), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0002.assertElementValidationEvent((Event)events.get(2), child, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0002.assertPropertyValidationEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_CHILDREN, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0002.assertElementValidationEvent((Event)events.get(4), root, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        events.clear();
        ChildElement child2 = (ChildElement)root.getChildren().insert();
        child2.attach(listener);
        ChildElement child3 = (ChildElement)root.getChildren().insert();
        child3.attach(listener);
        TestModelingEvents0002.assertEquals((int)2, (int)events.size());
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_CHILDREN);
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILDREN);
        events.clear();
        root.getChildren().move((IModelElement)child3, 0);
        TestModelingEvents0002.assertEquals((int)1, (int)events.size());
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_CHILDREN);
        events.clear();
        root.getChildren().remove((Object)child2);
        root.getChildren().remove((Object)child3);
        TestModelingEvents0002.assertEquals((int)4, (int)events.size());
        TestModelingEvents0002.assertElementDisposeEvent((Event)events.get(0), child2);
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILDREN);
        TestModelingEvents0002.assertElementDisposeEvent((Event)events.get(2), child3);
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_CHILDREN);
        events.clear();
        root.setEnablement(false);
        root.setEnablement(true);
        TestModelingEvents0002.assertEquals((int)6, (int)events.size());
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0002.assertPropertyEnablementEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILDREN, true, false);
        TestModelingEvents0002.assertPropertyEnablementEvent((Event)events.get(2), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, true, false);
        TestModelingEvents0002.assertPropertyContentEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0002.assertPropertyEnablementEvent((Event)events.get(4), root, (ModelProperty)RootElement.PROP_CHILDREN, false, true);
        TestModelingEvents0002.assertPropertyEnablementEvent((Event)events.get(5), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, false, true);
        events.clear();
        root.dispose();
        TestModelingEvents0002.assertEquals((int)2, (int)events.size());
        TestModelingEvents0002.assertElementDisposeEvent((Event)events.get(0), root);
        TestModelingEvents0002.assertElementDisposeEvent((Event)events.get(1), child);
    }
}

