/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0004;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.t0004.ChildElement;
import org.eclipse.sapphire.tests.modeling.events.t0004.RootElement;

public final class TestModelingEvents0004
extends SapphireTestCase {
    private TestModelingEvents0004(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingEvents0004");
        suite.addTest((Test)new TestModelingEvents0004("testImpliedElementPropertyEvents"));
        return suite;
    }

    public void testImpliedElementPropertyEvents() throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate();
        final ArrayList events = new ArrayList();
        Listener listener = new Listener(){

            public void handle(Event event) {
                events.add(event);
            }
        };
        root.attach(listener);
        root.validation();
        TestModelingEvents0004.assertEquals((int)2, (int)events.size());
        TestModelingEvents0004.assertPropertyInitializationEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0004.assertPropertyInitializationEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD);
        events.clear();
        ChildElement child = root.getChild();
        child.attach(listener);
        child.setIntegerValue("abc");
        TestModelingEvents0004.assertEquals((int)5, (int)events.size());
        TestModelingEvents0004.assertPropertyContentEvent((Event)events.get(0), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE);
        TestModelingEvents0004.assertPropertyValidationEvent((Event)events.get(1), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0004.assertElementValidationEvent((Event)events.get(2), child, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0004.assertPropertyValidationEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_CHILD, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        TestModelingEvents0004.assertElementValidationEvent((Event)events.get(4), root, Status.createOkStatus(), Status.createErrorStatus((String)"\"abc\" is not a valid integer."));
        events.clear();
        root.setEnablement(false);
        root.setEnablement(true);
        TestModelingEvents0004.assertEquals((int)6, (int)events.size());
        TestModelingEvents0004.assertPropertyContentEvent((Event)events.get(0), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0004.assertPropertyEnablementEvent((Event)events.get(1), root, (ModelProperty)RootElement.PROP_CHILD, true, false);
        TestModelingEvents0004.assertPropertyEnablementEvent((Event)events.get(2), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, true, false);
        TestModelingEvents0004.assertPropertyContentEvent((Event)events.get(3), root, (ModelProperty)RootElement.PROP_ENABLEMENT);
        TestModelingEvents0004.assertPropertyEnablementEvent((Event)events.get(4), root, (ModelProperty)RootElement.PROP_CHILD, false, true);
        TestModelingEvents0004.assertPropertyEnablementEvent((Event)events.get(5), child, (ModelProperty)ChildElement.PROP_INTEGER_VALUE, false, true);
        events.clear();
        root.dispose();
        TestModelingEvents0004.assertEquals((int)2, (int)events.size());
        TestModelingEvents0004.assertElementDisposeEvent((Event)events.get(0), root);
        TestModelingEvents0004.assertElementDisposeEvent((Event)events.get(1), child);
    }
}

