/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0007.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.tests.modeling.misc.t0007.TestChildElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestChildElementImpl
extends ModelElement
implements TestChildElement {
    private Value<String> pId;

    public TestChildElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestChildElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getId() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pId == null) {
                this.refresh((ModelProperty)PROP_ID, true);
            }
            return this.pId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ID.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_ID, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_ID, true);
            if (!TestChildElementImpl.equal((String)this.pId.getText(false), (String)value)) {
                this.resource().binding(PROP_ID).write(value);
                this.refresh((ModelProperty)PROP_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ID && (this.pId != null || force)) {
                Value<String> oldValue = this.pId;
                String val = this.resource().binding(PROP_ID).read();
                this.pId = new Value((IModelElement)this, PROP_ID, ((ValueNormalizationService)this.service((ModelProperty)PROP_ID, ValueNormalizationService.class)).normalize(PROP_ID.encodeKeywords(val)));
                this.pId.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_ID);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_ID));
                } else {
                    if (this.pId.equals(oldValue)) {
                        this.pId = oldValue;
                    } else {
                        if (!TestChildElementImpl.equal((String)this.pId.getText(false), (String)oldValue.getText(false)) || !TestChildElementImpl.equal((String)this.pId.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_ID));
                        }
                        if (!this.pId.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_ID, oldValue.validation(), this.pId.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_ID, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ID) {
            return this.getId();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_ID) {
            this.setId((String)value);
            return;
        }
        super.write(property, value);
    }
}

