/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0015.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.tests.modeling.misc.t0015.ChildElement;
import org.eclipse.sapphire.tests.modeling.misc.t0015.RootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RootElementImpl
extends ModelElement
implements RootElement {
    private ModelElementHandle<ChildElement> pFinal;
    private ModelElementHandle<ChildElement> pFor;
    private ModelElementList<ChildElement> pInterface;
    private Transient<ChildElement> pPublic;
    private Value<String> pSwitch;

    public RootElementImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public RootElementImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildElement getFinal() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pFinal == null) {
                this.refresh((ModelProperty)PROP_FINAL, true);
            }
            return (ChildElement)this.pFinal.element();
        }
    }

    protected void disposeProperties() {
        IModelElement element2;
        if (this.pFinal != null && (element2 = this.pFinal.element(false)) != null) {
            element2.dispose();
        }
        if (this.pFor != null && (element2 = this.pFor.element(false)) != null) {
            element2.dispose();
        }
        if (this.pInterface != null) {
            for (IModelElement element2 : this.pInterface) {
                element2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ChildElement> getFor() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pFor == null) {
                this.refresh((ModelProperty)PROP_FOR, true);
            }
            return this.pFor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ChildElement> getInterface() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pInterface == null) {
                this.refresh((ModelProperty)PROP_INTERFACE, true);
            }
            return this.pInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transient<ChildElement> getPublic() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pPublic == null) {
                this.refresh((ModelProperty)PROP_PUBLIC, true);
            }
            return this.pPublic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublic(ChildElement object) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Transient<ChildElement> oldTransient = this.pPublic;
            this.pPublic = new Transient((IModelElement)this, PROP_PUBLIC, (Object)object);
            this.pPublic.init();
            ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_PUBLIC);
            if (oldTransient == null) {
                this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_PUBLIC));
                if (object != null) {
                    this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_PUBLIC));
                }
            } else if (this.pPublic.equals(oldTransient)) {
                this.pPublic = oldTransient;
            } else {
                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_PUBLIC));
            }
            if (enablementRefreshResult.changed()) {
                this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_PUBLIC, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getSwitch() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pSwitch == null) {
                this.refresh((ModelProperty)PROP_SWITCH, true);
            }
            return this.pSwitch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSwitch(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SWITCH.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_SWITCH, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_SWITCH, true);
            if (!RootElementImpl.equal((String)this.pSwitch.getText(false), (String)value)) {
                this.resource().binding(PROP_SWITCH).write(value);
                this.refresh((ModelProperty)PROP_SWITCH, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_FINAL) {
                if (this.pFinal == null) {
                    if (force) {
                        this.pFinal = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_FINAL);
                        this.pFinal.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_FINAL);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_FINAL));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_FINAL);
                    boolean notified = this.pFinal.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_FINAL, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_FOR) {
                if (this.pFor == null) {
                    if (force) {
                        this.pFor = new ModelElementHandle((IModelElement)this, PROP_FOR);
                        this.pFor.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_FOR);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_FOR));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_FOR);
                    boolean notified = this.pFor.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_FOR, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_INTERFACE) {
                if (this.pInterface == null) {
                    if (force) {
                        this.pInterface = new ModelElementList((IModelElement)this, PROP_INTERFACE);
                        ListBindingImpl binding = this.resource().binding(PROP_INTERFACE);
                        this.pInterface.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_INTERFACE);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_INTERFACE));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_INTERFACE);
                    boolean notified = this.pInterface.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_INTERFACE, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            } else if (property == PROP_PUBLIC) {
                if (this.pPublic == null) {
                    if (force) {
                        this.setPublic(null);
                    }
                } else {
                    this.setPublic((ChildElement)this.pPublic.content());
                }
            } else if (property == PROP_SWITCH && (this.pSwitch != null || force)) {
                Value<String> oldValue = this.pSwitch;
                String val = this.resource().binding(PROP_SWITCH).read();
                this.pSwitch = new Value((IModelElement)this, PROP_SWITCH, ((ValueNormalizationService)this.service((ModelProperty)PROP_SWITCH, ValueNormalizationService.class)).normalize(PROP_SWITCH.encodeKeywords(val)));
                this.pSwitch.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_SWITCH);
                if (oldValue == null) {
                    this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_SWITCH));
                } else {
                    if (this.pSwitch.equals(oldValue)) {
                        this.pSwitch = oldValue;
                    } else {
                        if (!RootElementImpl.equal((String)this.pSwitch.getText(false), (String)oldValue.getText(false)) || !RootElementImpl.equal((String)this.pSwitch.getDefaultText(), (String)oldValue.getDefaultText())) {
                            this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_SWITCH));
                        }
                        if (!this.pSwitch.validation().equals((Object)oldValue.validation())) {
                            this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_SWITCH, oldValue.validation(), this.pSwitch.validation()));
                        }
                    }
                    if (enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_SWITCH, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_FINAL) {
            return this.getFinal();
        }
        if (property == PROP_FOR) {
            return this.getFor();
        }
        if (property == PROP_INTERFACE) {
            return this.getInterface();
        }
        if (property == PROP_PUBLIC) {
            return this.getPublic();
        }
        if (property == PROP_SWITCH) {
            return this.getSwitch();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_SWITCH) {
            this.setSwitch((String)value);
            return;
        }
        super.write(property, value);
    }

    public void write(TransientProperty property, Object object) {
        if ((property = (TransientProperty)property.refine((IModelElement)this)) == PROP_PUBLIC) {
            this.setPublic((ChildElement)object);
            return;
        }
        super.write(property, object);
    }
}

