/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0002;

import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0002.TestXmlXsd0002Element2b;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0002.TestXmlXsd0002ModelRoot;

public final class TestXmlXsd0002
extends SapphireTestCase {
    private static final String SCHEMA_LOCATION = "http://www.eclipse.org/sapphire/tests/xml/xsd/0002";

    private TestXmlXsd0002(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlXsd0002");
        suite.addTest((Test)new TestXmlXsd0002("testSchemaParsing"));
        suite.addTest((Test)new TestXmlXsd0002("testInsertOrder"));
        return suite;
    }

    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)SCHEMA_LOCATION, null);
        XmlElementDefinition rootElementDef = schema.getElement("element");
        XmlSequenceGroup rootContentModel = (XmlSequenceGroup)rootElementDef.getContentModel();
        List nestedContent = rootContentModel.getNestedContent();
        TestXmlXsd0002.assertEquals((int)4, (int)nestedContent.size());
        TestXmlXsd0002.assertEquals((String)"aaa", (String)((XmlElementDefinition)nestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((String)"bbb", (String)((XmlElementDefinition)nestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((String)"ccc", (String)((XmlElementDefinition)nestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((String)"element-2b", (String)((XmlElementDefinition)nestedContent.get(3)).getName().getLocalPart());
        XmlSequenceGroup childContentModel = (XmlSequenceGroup)rootContentModel.findChildElementContentModel(new QName(SCHEMA_LOCATION, "element-2b"));
        List childNestedContent = childContentModel.getNestedContent();
        TestXmlXsd0002.assertEquals((int)3, (int)childNestedContent.size());
        TestXmlXsd0002.assertEquals((String)"aaa-2b", (String)((XmlElementDefinition)childNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((String)"bbb-2b", (String)((XmlElementDefinition)childNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0002.assertEquals((String)"ccc-2b", (String)((XmlElementDefinition)childNestedContent.get(2)).getName().getLocalPart());
    }

    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0002ModelRoot model = (TestXmlXsd0002ModelRoot)TestXmlXsd0002ModelRoot.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        model.setCcc("ccc");
        model.setAaa("aaa");
        TestXmlXsd0002Element2b element2b = model.getElement2();
        element2b.setCcc2("ccc2");
        element2b.setBbb2("bbb2");
        element2b.setAaa2("aaa2");
        model.setBbb("bbb");
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlXsd0002.assertEqualsIgnoreNewLineDiffs(this.loadResource("0002.txt"), result);
    }
}

