/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0003;

import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0003.TestXmlXsd0003Circle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0003.TestXmlXsd0003Element;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0003.TestXmlXsd0003Square;

public final class TestXmlXsd0003
extends SapphireTestCase {
    private static final String SCHEMA_LOCATION = "http://www.eclipse.org/sapphire/tests/xml/xsd/0003";

    private TestXmlXsd0003(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlXsd0003");
        suite.addTest((Test)new TestXmlXsd0003("testSchemaParsing"));
        suite.addTest((Test)new TestXmlXsd0003("testInsertOrder"));
        return suite;
    }

    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)SCHEMA_LOCATION, null);
        XmlElementDefinition rootElementDef = schema.getElement("element");
        XmlSequenceGroup rootContentModel = (XmlSequenceGroup)rootElementDef.getContentModel();
        List nestedContent = rootContentModel.getNestedContent();
        TestXmlXsd0003.assertEquals((int)4, (int)nestedContent.size());
        TestXmlXsd0003.assertEquals((String)"shape", (String)((XmlElementDefinition)nestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0003.assertEquals((String)"aaa", (String)((XmlElementDefinition)nestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0003.assertEquals((String)"bbb", (String)((XmlElementDefinition)nestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0003.assertEquals((String)"ccc", (String)((XmlElementDefinition)nestedContent.get(3)).getName().getLocalPart());
        XmlContentModel circleContentModel = rootContentModel.findChildElementContentModel(new QName(SCHEMA_LOCATION, "circle"));
        TestXmlXsd0003.assertNotNull((Object)circleContentModel);
        XmlContentModel squareContentModel = rootContentModel.findChildElementContentModel(new QName(SCHEMA_LOCATION, "square"));
        TestXmlXsd0003.assertNotNull((Object)squareContentModel);
    }

    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0003Element model = (TestXmlXsd0003Element)TestXmlXsd0003Element.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        model.setCcc("ccc");
        model.setBbb("bbb");
        TestXmlXsd0003Circle circle = model.getCircle();
        circle.setCircle3("333");
        circle.setCircle2("222");
        circle.setCircle1("111");
        model.setAaa("aaa");
        TestXmlXsd0003Square square = model.getSquare();
        square.setSquare3("333");
        square.setSquare2("222");
        square.setSquare1("111");
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlXsd0003.assertEqualsIgnoreNewLineDiffs(this.loadResource("0003.txt"), result);
    }
}

