/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.contextbuttons;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.Rectangle;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPadData;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.PositionedContextButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextButtonPadDeclaration
implements IContextButtonPadDeclaration {
    private java.awt.Rectangle originalReferenceRectangle;
    private java.awt.Rectangle padReferenceRectangle;
    private ContextButtonPadData contextButtonPadData;
    private List<SapphireAction> collapseAndGenericButtons;
    private List<SapphireAction> domainButtonsRight;
    private List<SapphireAction> domainButtonsBottom;
    private java.awt.Rectangle top;
    private java.awt.Rectangle right;
    private java.awt.Rectangle bottom;
    private IContextButtonPadDeclaration.PadStyle topStyle = IContextButtonPadDeclaration.PadStyle.STANDARD;
    private IContextButtonPadDeclaration.PadStyle rightStyle = IContextButtonPadDeclaration.PadStyle.STANDARD;
    private List<PositionedContextButton> positionedButtons;
    private List<java.awt.Rectangle> containmentRectangles;
    private List<java.awt.Rectangle> overlappingContainmentRectangles;

    public AbstractContextButtonPadDeclaration(ContextButtonPadData contextButtonPadData) {
        this.contextButtonPadData = contextButtonPadData;
        Rectangle l = contextButtonPadData.getPadLocation();
        this.originalReferenceRectangle = new java.awt.Rectangle(l.getX(), l.getY(), l.getWidth(), l.getHeight());
        this.padReferenceRectangle = new java.awt.Rectangle(this.originalReferenceRectangle);
        this.padReferenceRectangle.grow(1, 1);
        this.initializeDomainButtonLists();
        this.initializeRectangles();
        this.initializeButtonPositions();
        this.initializeContainmentRectangles();
    }

    protected abstract int getButtonSize();

    protected abstract int getButtonPadding();

    protected abstract int getCollapseButtonPadding();

    protected abstract int getPadPaddingOutside();

    protected abstract int getPadPaddingInside();

    protected abstract int getPadHorizontalOverlap();

    protected abstract int getPadVerticalOverlap();

    protected abstract int getPadAppendageLength();

    public abstract PositionedContextButton createButton(SapphireAction var1, java.awt.Rectangle var2);

    @Override
    public java.awt.Rectangle getTopPad() {
        return this.top;
    }

    @Override
    public java.awt.Rectangle getRightPad() {
        return this.right;
    }

    @Override
    public java.awt.Rectangle getBottomPad() {
        return this.bottom;
    }

    @Override
    public IContextButtonPadDeclaration.PadStyle getTopPadStyle() {
        return this.topStyle;
    }

    @Override
    public IContextButtonPadDeclaration.PadStyle getRightPadStyle() {
        return this.rightStyle;
    }

    protected final java.awt.Rectangle getOriginalReferenceRectangle() {
        return this.originalReferenceRectangle;
    }

    protected final java.awt.Rectangle getPadReferenceRectangle() {
        return this.padReferenceRectangle;
    }

    protected final List<SapphireAction> getGenericButtons() {
        return this.contextButtonPadData.getTopContextButtons();
    }

    protected final List<SapphireAction> getCollapseAndGenericButtons() {
        if (this.collapseAndGenericButtons == null) {
            this.collapseAndGenericButtons = new ArrayList<SapphireAction>(this.getGenericButtons().size() + 1);
            this.collapseAndGenericButtons.addAll(this.getGenericButtons());
        }
        return this.collapseAndGenericButtons;
    }

    protected final List<SapphireAction> getDomainButtons() {
        return this.contextButtonPadData.getRightContextButtons();
    }

    protected final List<SapphireAction> getDomainButtonsRight() {
        return this.domainButtonsRight;
    }

    protected final List<SapphireAction> getDomainButtonsBottom() {
        return this.domainButtonsBottom;
    }

    @Override
    public final List<PositionedContextButton> getPositionedContextButtons() {
        return this.positionedButtons;
    }

    @Override
    public final List<java.awt.Rectangle> getContainmentRectangles() {
        return this.containmentRectangles;
    }

    @Override
    public final List<java.awt.Rectangle> getOverlappingContainmentRectangles() {
        return this.overlappingContainmentRectangles;
    }

    protected void initializeDomainButtonLists() {
        int maxNumberOfButtons;
        int referenceHeight = this.getPadReferenceRectangle().height + 2 * this.getPadVerticalOverlap();
        if ((referenceHeight -= 2 * this.getPadPaddingOutside() + this.getButtonSize()) < 0) {
            maxNumberOfButtons = 0;
        } else {
            double additionalButtons = (double)referenceHeight / (double)(this.getButtonSize() + this.getButtonPadding());
            maxNumberOfButtons = 1 + (int)Math.ceil(additionalButtons);
        }
        this.domainButtonsRight = new ArrayList<SapphireAction>();
        int i = 0;
        while (i < maxNumberOfButtons && i < this.getDomainButtons().size()) {
            this.domainButtonsRight.add(this.getDomainButtons().get(i));
            ++i;
        }
        int rightSize = this.getDomainButtonsRight().size();
        this.domainButtonsBottom = new ArrayList<SapphireAction>();
        int i2 = rightSize;
        while (i2 < this.getDomainButtons().size()) {
            this.domainButtonsBottom.add(this.getDomainButtons().get(i2));
            ++i2;
        }
    }

    protected void initializeRectangles() {
        java.awt.Rectangle innerRectangle = new java.awt.Rectangle(this.getPadReferenceRectangle());
        innerRectangle.height = this.getPadDynamicSize(this.getDomainButtonsRight().size());
        innerRectangle.height -= 2 * this.getPadVerticalOverlap();
        if (this.getDomainButtonsBottom().size() > 0 && innerRectangle.height > this.getPadReferenceRectangle().height) {
            innerRectangle.y -= (innerRectangle.height - this.getPadReferenceRectangle().height + 1) / 2;
        }
        Point innerTop = new Point(innerRectangle.x + innerRectangle.width, innerRectangle.y);
        Point innerBottom = new Point(innerTop.x, innerTop.y + innerRectangle.height);
        if (this.getCollapseAndGenericButtons().size() != 0) {
            this.top = new java.awt.Rectangle();
            this.top.width = this.getPadDynamicSize(this.getCollapseAndGenericButtons().size());
            this.top.height = this.getPadConstantSize();
            this.top.x = innerTop.x - this.top.width + this.getPadHorizontalOverlap();
            this.top.y = innerTop.y - this.top.height;
        } else if (this.getPadAppendageLength() > 0) {
            this.topStyle = IContextButtonPadDeclaration.PadStyle.APPENDAGE;
            this.top = new java.awt.Rectangle();
            this.top.width = this.getPadAppendageLength() + this.getPadHorizontalOverlap();
            this.top.height = this.getPadVerticalOverlap();
            this.top.x = innerTop.x - this.top.width + this.getPadHorizontalOverlap();
            this.top.y = innerTop.y - this.top.height;
        }
        if (this.getDomainButtonsRight().size() != 0) {
            this.right = new java.awt.Rectangle();
            this.right.width = this.getPadConstantSize();
            this.right.height = this.getPadDynamicSize(this.getDomainButtonsRight().size());
            this.right.x = innerTop.x;
            this.right.y = innerTop.y - this.getPadVerticalOverlap();
        } else if (this.getPadAppendageLength() > 0) {
            this.rightStyle = IContextButtonPadDeclaration.PadStyle.APPENDAGE;
            this.right = new java.awt.Rectangle();
            this.right.width = this.getPadHorizontalOverlap();
            this.right.height = this.getPadAppendageLength() + this.getPadVerticalOverlap();
            this.right.x = innerTop.x;
            this.right.y = innerTop.y - this.getPadVerticalOverlap();
        }
        if (this.getDomainButtonsBottom().size() != 0) {
            this.bottom = new java.awt.Rectangle();
            this.bottom.width = this.getPadDynamicSize(this.getDomainButtonsBottom().size());
            this.bottom.height = this.getPadConstantSize();
            this.bottom.x = innerBottom.x - this.bottom.width + this.getPadHorizontalOverlap();
            this.bottom.y = innerBottom.y;
        }
    }

    protected void initializeButtonPositions() {
        java.awt.Rectangle position;
        int y;
        int x;
        int iBackwards;
        this.positionedButtons = new ArrayList<PositionedContextButton>();
        int i = 0;
        while (i < this.getCollapseAndGenericButtons().size()) {
            iBackwards = this.getCollapseAndGenericButtons().size() - 1 - i;
            x = this.top.x + this.getPadPaddingOutside() + iBackwards * (this.getButtonSize() + this.getButtonPadding());
            y = this.top.y + this.getPadPaddingInside();
            position = new java.awt.Rectangle(x, y, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getCollapseAndGenericButtons().get(i), position));
            ++i;
        }
        i = 0;
        while (i < this.getDomainButtonsRight().size()) {
            int x2 = this.right.x + this.getPadPaddingInside();
            int y2 = this.right.y + this.getPadPaddingOutside() + i * (this.getButtonSize() + this.getButtonPadding());
            java.awt.Rectangle position2 = new java.awt.Rectangle(x2, y2, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getDomainButtonsRight().get(i), position2));
            ++i;
        }
        i = 0;
        while (i < this.getDomainButtonsBottom().size()) {
            iBackwards = this.getDomainButtonsBottom().size() - 1 - i;
            x = this.bottom.x + this.getPadPaddingOutside() + iBackwards * (this.getButtonSize() + this.getButtonPadding());
            y = this.bottom.y + this.getPadPaddingInside();
            position = new java.awt.Rectangle(x, y, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getDomainButtonsBottom().get(i), position));
            ++i;
        }
    }

    protected void initializeContainmentRectangles() {
        this.containmentRectangles = new ArrayList<java.awt.Rectangle>();
        this.overlappingContainmentRectangles = new ArrayList<java.awt.Rectangle>();
        if (this.getTopPad() != null) {
            this.containmentRectangles.add(this.getTopPad());
        }
        if (this.getRightPad() != null) {
            this.containmentRectangles.add(this.getRightPad());
        }
        if (this.getBottomPad() != null) {
            this.containmentRectangles.add(this.getBottomPad());
        }
        for (PositionedContextButton button : this.getPositionedContextButtons()) {
            boolean buttonInside = false;
            for (java.awt.Rectangle rectangle : this.containmentRectangles) {
                if (!rectangle.contains(button.getPosition())) continue;
                buttonInside = true;
                break;
            }
            if (buttonInside) continue;
            this.containmentRectangles.add(button.getPosition());
        }
        java.awt.Rectangle r = this.getOriginalReferenceRectangle();
        Point referencePoint = new Point(r.x + r.width / 2, r.y + r.height / 2);
        for (java.awt.Rectangle rectangle : this.containmentRectangles) {
            java.awt.Rectangle unionRectangle = rectangle.union(new java.awt.Rectangle(referencePoint));
            this.overlappingContainmentRectangles.add(unionRectangle);
        }
        this.overlappingContainmentRectangles.add(this.getOriginalReferenceRectangle());
    }

    private int getPadConstantSize() {
        return this.getPadPaddingInside() + this.getButtonSize() + this.getPadPaddingInside();
    }

    private int getPadDynamicSize(int numberOfButtons) {
        return 2 * this.getPadPaddingOutside() + numberOfButtons * this.getButtonSize() + (numberOfButtons - 1) * this.getButtonPadding();
    }
}

