/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.sapphire.ui.swt.gef.figures.BezierPoint;
import org.eclipse.swt.graphics.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureUtil {
    public static PointList getAdjustedPointList(PointList points, double zoom, double lw) {
        Rectangle zoomedBounds = points.getBounds().getCopy().scale(zoom);
        double middlex = zoomedBounds.x + zoomedBounds.width / 2;
        double middley = zoomedBounds.y + zoomedBounds.height / 2;
        PointList ret = new PointList();
        int i = 0;
        while (i < points.size()) {
            Point point = points.getPoint(i);
            point.scale(zoom);
            double dx = (double)point.x < middlex ? Math.ceil((middlex - (double)point.x) / (double)zoomedBounds.width * lw) : Math.floor((middlex - (double)point.x) / (double)zoomedBounds.width * lw);
            double dy = (double)point.y < middley ? Math.ceil((middley - (double)point.y) / (double)zoomedBounds.height * lw) : Math.floor((middley - (double)point.y) / (double)zoomedBounds.height * lw);
            point.translate((int)dx, (int)dy);
            ret.addPoint(point);
            ++i;
        }
        return ret;
    }

    public static Path getBezierPath(List<BezierPoint> origPoints, boolean isClosed) {
        Path path = new Path(null);
        ArrayList<BezierPoint> points = new ArrayList<BezierPoint>(origPoints.size() + 2);
        points.addAll(origPoints);
        if (points.size() < 3 || !FigureUtil.hasBezierDistance(origPoints)) {
            if (points.size() != 0) {
                path.moveTo((float)((BezierPoint)points.get(0)).getX(), (float)((BezierPoint)points.get(0)).getY());
                int i = 1;
                while (i < points.size()) {
                    path.lineTo((float)((BezierPoint)points.get(i)).getX(), (float)((BezierPoint)points.get(i)).getY());
                    ++i;
                }
            }
        } else {
            if (isClosed) {
                if (!((BezierPoint)points.get(points.size() - 1)).equals(points.get(0))) {
                    points.add((BezierPoint)points.get(0));
                }
                points.add((BezierPoint)points.get(1));
            }
            Point c = ((BezierPoint)points.get(0)).createDraw2dPoint();
            Point q = ((BezierPoint)points.get(1)).createDraw2dPoint();
            Point r = new Point();
            Point s = new Point();
            FigureUtil.determineBezierPoints(c, q, r, s, ((BezierPoint)points.get(0)).getBezierDistanceAfter(), ((BezierPoint)points.get(1)).getBezierDistanceBefore());
            if (!isClosed) {
                path.moveTo((float)((BezierPoint)points.get(0)).getX(), (float)((BezierPoint)points.get(0)).getY());
                path.lineTo((float)r.x, (float)r.y);
            } else {
                path.moveTo((float)r.x, (float)r.y);
            }
            int index = 2;
            while (index < points.size()) {
                c.setLocation(q);
                ((BezierPoint)points.get(index)).copyToDraw2dPoint(q);
                FigureUtil.determineBezierPoints(c, q, r, s, ((BezierPoint)points.get(index - 1)).getBezierDistanceAfter(), ((BezierPoint)points.get(index)).getBezierDistanceBefore());
                path.quadTo((float)c.x, (float)c.y, (float)s.x, (float)s.y);
                path.lineTo((float)r.x, (float)r.y);
                ++index;
            }
            if (!isClosed) {
                path.lineTo((float)((BezierPoint)points.get(points.size() - 1)).getX(), (float)((BezierPoint)points.get(points.size() - 1)).getY());
            }
        }
        if (isClosed) {
            path.close();
        }
        return path;
    }

    public static boolean hasBezierDistance(List<BezierPoint> points) {
        for (BezierPoint point : points) {
            if (point.getBezierDistanceBefore() == 0 && point.getBezierDistanceAfter() == 0) continue;
            return true;
        }
        return false;
    }

    private static void determineBezierPoints(Point c, Point q, Point r, Point s, int distanceAfterCurrent, int distanceBeforeNext) {
        int vx = q.x - c.x;
        int vy = q.y - c.y;
        Vector v = new Vector((double)vx, (double)vy);
        double absV = v.getLength();
        int mx = Math.round(c.x + vx / 2);
        int my = Math.round(c.y + vy / 2);
        int tolerance = distanceAfterCurrent + distanceBeforeNext;
        if (absV < (double)tolerance) {
            r.x = mx;
            r.y = my;
            s.x = mx;
            s.y = my;
        } else {
            double x = (absV - (double)distanceBeforeNext) / absV;
            r.x = Math.round((float)c.x + (float)x * (float)vx);
            r.y = Math.round((float)c.y + (float)x * (float)vy);
            double y = (double)distanceAfterCurrent / absV;
            s.x = Math.round((float)c.x + (float)y * (float)vx);
            s.y = Math.round((float)c.y + (float)y * (float)vy);
        }
    }
}

