/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActuatorDef;
import org.eclipse.sapphire.ui.def.HorizontalAlignment;
import org.eclipse.sapphire.ui.def.ImageReference;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActuatorPart
extends SapphirePart {
    private SapphireAction action;
    private String actionId;
    private Listener actionListener;
    private SapphireActionHandler actionHandler;
    private String actionHandlerId;
    private Listener actionHandlerListener;
    private boolean showLabel;
    private FunctionResult labelFunctionResult;
    private boolean showImage;
    private List<FunctionResult> imageFunctionResults;
    private String style;

    @Override
    protected void init() {
        super.init();
        ActuatorDef def = this.definition();
        this.actionId = (String)def.getActionId().getContent();
        this.actionHandlerId = (String)def.getActionHandlerId().getContent();
        IModelElement element = this.getLocalModelElement();
        this.showLabel = (Boolean)def.getShowLabel().getContent();
        if (this.showLabel) {
            this.labelFunctionResult = this.initExpression(element, (Function)def.getLabel().getContent(), String.class, null, new Runnable(){

                public void run() {
                    ActuatorPart.this.broadcast(new SapphirePart.LabelChangedEvent(ActuatorPart.this));
                }
            });
        }
        this.showImage = (Boolean)def.getShowImage().getContent();
        if (this.showImage) {
            ReadOnlyListFactory imageFunctionResultsFactory = ReadOnlyListFactory.create();
            for (ImageReference imageReference : def.getImages()) {
                FunctionResult imageFunctionResult = this.initExpression(element, (Function)imageReference.getImage().getContent(), ImageData.class, null, new Runnable(){

                    public void run() {
                        ActuatorPart.this.broadcast(new SapphirePart.ImageChangedEvent(ActuatorPart.this));
                    }
                });
                imageFunctionResultsFactory.add((Object)imageFunctionResult);
            }
            this.imageFunctionResults = imageFunctionResultsFactory.export();
        }
        this.style = (String)def.getStyle().getContent();
    }

    private void refreshActionHandler() {
        if (this.actionHandler != null) {
            this.actionHandler.detach(this.actionHandlerListener);
            this.actionHandler = null;
        }
        SapphireAction action = this.action();
        if (this.actionHandlerId == null) {
            this.actionHandler = action.getFirstActiveHandler();
        } else {
            for (SapphireActionHandler h : action.getActiveHandlers()) {
                if (!h.getId().equalsIgnoreCase(this.actionHandlerId)) continue;
                this.actionHandler = h;
                break;
            }
        }
        if (this.actionHandler != null) {
            if (this.actionHandlerListener == null) {
                this.actionHandlerListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                            ActuatorPart.this.broadcast(new EnablementChangedEvent(ActuatorPart.this));
                        }
                    }
                };
            }
            this.actionHandler.attach(this.actionHandlerListener);
        }
    }

    @Override
    public ActuatorDef definition() {
        return (ActuatorDef)super.definition();
    }

    public SapphireAction action() {
        if (this.action == null) {
            this.action = this.getAction(this.actionId);
            this.actionListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphireAction.HandlersChangedEvent) {
                        ActuatorPart.this.refreshActionHandler();
                    } else if (event instanceof SapphireActionSystemPart.LabelChangedEvent) {
                        ActuatorPart.this.broadcast(new SapphirePart.LabelChangedEvent(ActuatorPart.this));
                    } else if (event instanceof SapphireActionSystemPart.ImagesChangedEvent) {
                        ActuatorPart.this.broadcast(new SapphirePart.ImageChangedEvent(ActuatorPart.this));
                    }
                }
            };
            this.action.attach(this.actionListener);
        }
        return this.action;
    }

    public SapphireActionHandler handler() {
        if (this.actionHandler == null) {
            this.refreshActionHandler();
        }
        return this.actionHandler;
    }

    public boolean enabled() {
        SapphireActionHandler handler = this.handler();
        return handler != null && handler.isEnabled();
    }

    public String label() {
        return this.label(CapitalizationType.NO_CAPS);
    }

    public String label(CapitalizationType capitalizationType) {
        return this.label(capitalizationType, false);
    }

    public String label(CapitalizationType capitalizationType, boolean includeMnemonic) {
        if (this.showLabel) {
            SapphireAction action;
            String label = (String)this.labelFunctionResult.value();
            if (label == null && (action = this.action()) != null) {
                label = action.getLabel();
            }
            LocalizationService localizationService = (LocalizationService)this.definition.adapt(LocalizationService.class);
            return localizationService.text(label, capitalizationType, includeMnemonic);
        }
        return null;
    }

    public ImageData image(int size) {
        if (this.showImage) {
            for (FunctionResult imageFunctionResult : this.imageFunctionResults) {
                ImageData image = (ImageData)imageFunctionResult.value();
                if (image == null || SwtRendererUtil.sizeOfImage(image) != size) continue;
                return image;
            }
            SapphireAction action = this.action();
            if (action != null) {
                return action.getImage(size);
            }
        }
        return null;
    }

    public String style() {
        return this.style;
    }

    @Override
    public void render(final SapphireRenderingContext context) {
        int hSpan;
        SapphireActionGroup actions = this.getActions(this.getMainActionContext());
        final SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(actionPresentationManager);
        ActuatorDef def = this.definition();
        Composite parent = context.getComposite();
        HorizontalAlignment hAlign = (HorizontalAlignment)((Object)def.getHorizontalAlignment().getContent());
        int hAlignCode = hAlign == HorizontalAlignment.LEFT ? 16384 : (hAlign == HorizontalAlignment.RIGHT ? 131072 : 0x1000000);
        int n = hSpan = (Boolean)def.getSpanBothColumns().getContent() != false ? 2 : 1;
        if (hSpan == 1) {
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)GridLayoutUtil.gd());
            spacer.setText("");
            context.adapt((Control)spacer);
        }
        if (this.style().equals("Sapphire.Actuator.Button")) {
            ImageData image;
            final Button button = new Button(parent, 8);
            button.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhalign(GridLayoutUtil.gd(), hAlignCode), 8), hSpan));
            keyboardActionPresentation.attach((Control)button);
            String label = this.label(CapitalizationType.TITLE_STYLE, true);
            if (label != null) {
                button.setText(label);
            }
            if ((image = this.image(16)) != null) {
                button.setImage(this.getImageCache().getImage(image));
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SapphireActionHandler handler = ActuatorPart.this.handler();
                    if (handler != null) {
                        handler.execute(context);
                    }
                }
            });
            button.setEnabled(this.enabled());
            final Listener listener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof EnablementChangedEvent) {
                        button.setEnabled(ActuatorPart.this.enabled());
                    } else if (event instanceof SapphirePart.LabelChangedEvent) {
                        String label = ActuatorPart.this.label(CapitalizationType.TITLE_STYLE);
                        button.setText(label == null ? "" : label);
                        button.getParent().layout(true, true);
                    } else if (event instanceof SapphirePart.ImageChangedEvent) {
                        button.setImage(ActuatorPart.this.getImageCache().getImage(ActuatorPart.this.image(16)));
                    }
                }
            };
            this.attach(listener);
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    actionPresentationManager.dispose();
                    ActuatorPart.this.detach(listener);
                }
            });
        } else {
            Label imageControl;
            ImageData image = this.image(16);
            final Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)GridLayoutUtil.gdhalign(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gd(), hSpan), 8), hAlignCode));
            composite.setLayout((Layout)GridLayoutUtil.glayout(image == null ? 1 : 2, 0, 0));
            context.adapt((Control)composite);
            if (image != null) {
                imageControl = new Label(composite, 0);
                imageControl.setImage(this.getImageCache().getImage(image));
                imageControl.setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 0x1000000));
                imageControl.setEnabled(this.enabled());
                context.adapt((Control)imageControl);
            } else {
                imageControl = null;
            }
            final SapphireFormText text = new SapphireFormText(composite, 0);
            text.setLayoutData(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000));
            context.adapt((Control)text);
            keyboardActionPresentation.attach((Control)text);
            String label = this.label(CapitalizationType.FIRST_WORD_ONLY);
            label = label == null ? Resources.labelNotSpecified : label;
            StringBuilder buf = new StringBuilder();
            buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
            buf.append(label);
            buf.append("</a></p></form>");
            text.setText(buf.toString(), true, false);
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    SapphireActionHandler handler = ActuatorPart.this.handler();
                    if (handler != null) {
                        handler.execute(context);
                    }
                }
            });
            text.setEnabled(this.enabled());
            final Listener listener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof EnablementChangedEvent) {
                        boolean enabled = ActuatorPart.this.enabled();
                        if (imageControl != null) {
                            imageControl.setEnabled(enabled);
                        }
                        text.setEnabled(enabled);
                    } else if (event instanceof SapphirePart.LabelChangedEvent) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
                        buf.append(ActuatorPart.this.label(CapitalizationType.FIRST_WORD_ONLY));
                        buf.append("</a></p></form>");
                        text.setText(buf.toString(), true, false);
                        composite.getParent().layout(true, true);
                    } else if (event instanceof SapphirePart.ImageChangedEvent && imageControl != null) {
                        imageControl.setImage(ActuatorPart.this.getImageCache().getImage(ActuatorPart.this.image(16)));
                    }
                }
            };
            this.attach(listener);
            text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    actionPresentationManager.dispose();
                    ActuatorPart.this.detach(listener);
                }
            });
        }
        keyboardActionPresentation.render();
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Actuator");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.action != null) {
            this.action.detach(this.actionListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.detach(this.actionHandlerListener);
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.imageFunctionResults != null) {
            for (FunctionResult imageFunctionResult : this.imageFunctionResults) {
                imageFunctionResult.dispose();
            }
        }
    }

    public static final class EnablementChangedEvent
    extends SapphirePart.PartEvent {
        public EnablementChangedEvent(SapphirePart part) {
            super(part);
        }
    }

    private static final class Resources
    extends NLS {
        public static String labelNotSpecified;

        static {
            Resources.initializeMessages((String)ActuatorPart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

