/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.FormEditorPagePart;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.FormEditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class FormEditorPage
extends SapphireEditorFormPage {
    public FormEditorPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        this(editor, rootModelElement, pageDefinitionLocation, null);
    }

    public FormEditorPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation, String pageName) {
        super(editor, FormEditorPage.createEditorPagePart(editor, rootModelElement, pageDefinitionLocation));
        String partName = pageName;
        if (partName == null) {
            partName = this.getDefinition().getPageName().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        }
        this.setPartName(partName);
    }

    private static FormEditorPagePart createEditorPagePart(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, relPath);
        FormEditorPageDef editorPageDef = (FormEditorPageDef)def.getPartDef(pageId, true, FormEditorPageDef.class);
        if (editorPageDef == null) {
            throw new RuntimeException();
        }
        FormEditorPagePart editorPagePart = new FormEditorPagePart();
        editorPagePart.init(editor, rootModelElement, editorPageDef, Collections.<String, String>emptyMap());
        return editorPagePart;
    }

    public FormEditorPagePart getPart() {
        return (FormEditorPagePart)super.getPart();
    }

    public FormEditorPageDef getDefinition() {
        return this.getPart().definition();
    }

    public String getId() {
        return this.getPartName();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormEditorPagePart part = this.getPart();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(managedForm.getForm().getForm());
        managedForm.getForm().setText(this.getDefinition().getPageHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false));
        managedForm.getForm().getBody().setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        SapphireEditorFormPage.FormEditorRenderingContext context = new SapphireEditorFormPage.FormEditorRenderingContext((ISapphirePart)this.getPart(), managedForm);
        for (SapphirePart sapphirePart : part.getChildParts()) {
            sapphirePart.render(context);
        }
        ISapphireDocumentation iSapphireDocumentation = (ISapphireDocumentation)part.definition().getDocumentation().element();
        if (iSapphireDocumentation != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = iSapphireDocumentation instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)iSapphireDocumentation : ((ISapphireDocumentationRef)iSapphireDocumentation).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)managedForm.getForm().getBody(), docdef);
            }
        }
        SapphireActionGroup actions = part.getActions("Sapphire.EditorPage");
        SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(part, this.getSite().getShell(), actions);
        actionPresentation.setToolBarManager(form.getToolBarManager());
        actionPresentation.render();
    }
}

