/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireIfElseDirectiveDef;
import org.eclipse.sapphire.ui.def.PartDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IfThenElsePart
extends SapphirePart {
    private ISapphireIfElseDirectiveDef def;
    private SapphireCondition condition;
    private List<SapphirePart> currentBranchContent;
    private List<SapphirePart> currentBranchContentReadOnly;

    @Override
    protected void init() {
        Class conditionClass;
        super.init();
        this.def = (ISapphireIfElseDirectiveDef)this.definition;
        Status conditionClassValidation = this.def.getConditionClass().validation();
        if (conditionClassValidation.severity() != Status.Severity.ERROR) {
            conditionClass = ((JavaType)this.def.getConditionClass().resolve()).artifact();
        } else {
            LoggingService.log((Status)conditionClassValidation);
            conditionClass = null;
        }
        if (conditionClass != null) {
            String conditionParameter = this.def.getConditionParameter().getText();
            this.condition = SapphireCondition.create(this, conditionClass, conditionParameter);
            if (this.condition != null) {
                this.condition.attach(new Listener(){

                    public void handle(Event event) {
                        IfThenElsePart.this.handleConditionChanged();
                    }
                });
            }
        }
        this.currentBranchContent = new ArrayList<SapphirePart>();
        this.currentBranchContentReadOnly = Collections.unmodifiableList(this.currentBranchContent);
        this.handleConditionChanged(true);
    }

    private void handleConditionChanged() {
        this.handleConditionChanged(false);
    }

    private void handleConditionChanged(boolean initializing) {
        for (SapphirePart part : this.currentBranchContent) {
            part.dispose();
        }
        this.currentBranchContent.clear();
        if (this.condition != null) {
            IModelElement element = this.getLocalModelElement();
            Listener childPartListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphirePart.ValidationChangedEvent) {
                        IfThenElsePart.this.updateValidationState();
                    }
                }
            };
            for (PartDef childPartDef : this.condition.getConditionState() ? this.def.getThenContent() : this.def.getElseContent()) {
                SapphirePart childPart = IfThenElsePart.create(this, element, childPartDef, this.params);
                this.currentBranchContent.add(childPart);
                childPart.attach(childPartListener);
            }
        }
        this.updateValidationState();
        if (!initializing) {
            this.broadcast(new SapphirePart.StructureChangedEvent(this));
        }
    }

    public boolean getConditionState() {
        return this.condition != null ? this.condition.getConditionState() : false;
    }

    public List<SapphirePart> getCurrentBranchContent() {
        return this.currentBranchContentReadOnly;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        for (SapphirePart child : this.currentBranchContent) {
            child.render(context);
        }
    }

    @Override
    protected Status computeValidationState() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart child : this.currentBranchContent) {
            factory.merge(child.getValidationState());
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart child : this.currentBranchContent) {
            child.dispose();
        }
        if (this.condition != null) {
            this.condition.dispose();
        }
    }
}

