/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IContext;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.ui.CorruptedResourceExceptionInterceptorImpl;
import org.eclipse.sapphire.ui.ISapphireEditorActionContributor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.internal.PartServiceContext;
import org.eclipse.sapphire.ui.internal.SapphireActionManager;
import org.eclipse.sapphire.ui.internal.SapphireEditorContentOutline;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.EditorPagePresentation;
import org.eclipse.sapphire.ui.swt.SapphirePropertySheetPage;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.sapphire.util.ReadOnlyListFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireEditor
extends FormEditor
implements ISapphirePart {
    private static final String PREFS_LAST_ACTIVE_PAGE = "LastActivePage";
    private static final String PREFS_GLOBAL = "Global";
    private static final String PREFS_INSTANCE_BY_URI = "InstanceByUri";
    private static final String PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE = "InstanceByEditorInputType";
    private final String pluginId;
    private IModelElement model;
    private IResourceChangeListener fileChangeListener;
    private final SapphireImageCache imageCache;
    private SapphireEditorContentOutline outline;
    private final SapphireActionManager actionsManager;
    private SapphirePropertySheetPage propertiesViewPage;
    private Listener propertiesViewContributionChangeListener;
    private PartServiceContext serviceContext;

    public SapphireEditor(String pluginId) {
        this.pluginId = pluginId;
        this.imageCache = new SapphireImageCache();
        this.outline = null;
        this.actionsManager = new SapphireActionManager(this, this.getActionContexts());
    }

    public Composite getContainer() {
        return super.getContainer();
    }

    @Override
    public PartDef definition() {
        return null;
    }

    @Override
    public final IModelElement getModelElement() {
        return this.model;
    }

    @Override
    public final IModelElement getLocalModelElement() {
        return this.model;
    }

    protected abstract IModelElement createModel();

    protected void adaptModel(IModelElement model) {
        CorruptedResourceExceptionInterceptorImpl interceptor = new CorruptedResourceExceptionInterceptorImpl(this.getEditorSite().getShell());
        this.model.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
    }

    public final Preferences getGlobalPreferences(boolean createIfNecessary) throws BackingStoreException {
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(PREFS_GLOBAL) || createIfNecessary)) {
            return prefs.node(PREFS_GLOBAL);
        }
        return null;
    }

    public final Preferences getInstancePreferences(boolean createIfNecessary) throws BackingStoreException {
        String level2;
        String level1;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IURIEditorInput) {
            level1 = PREFS_INSTANCE_BY_URI;
            URI uri = ((IURIEditorInput)editorInput).getURI();
            level2 = uri != null ? ((IURIEditorInput)editorInput).getURI().toString() : "$#%**invalid**%#$";
        } else {
            level1 = PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE;
            level2 = editorInput.getClass().getName();
        }
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(level1) || createIfNecessary) && ((prefs = prefs.node(level1)).nodeExists(level2) || createIfNecessary)) {
            return prefs.node(level2);
        }
        return null;
    }

    private final Preferences getPreferencesRoot(boolean createIfNecessary) throws BackingStoreException {
        String editorId;
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences prefs = scope.getNode(this.pluginId);
        if (prefs.nodeExists(editorId = this.getClass().getName()) || createIfNecessary) {
            return prefs.node(editorId);
        }
        return null;
    }

    public final File getDefaultStateStorageFile(SapphireEditorPagePart part) {
        StringBuilder key = new StringBuilder();
        IEditorInput editorInput = this.getEditorInput();
        key.append(editorInput.getClass().getName());
        key.append('#');
        if (editorInput instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)editorInput).getURI();
            if (uri != null) {
                key.append(((IURIEditorInput)editorInput).getURI().toString());
            } else {
                key.append("%$**invalid**$%");
            }
            key.append('#');
        }
        key.append((String)part.definition().getPageName().getContent());
        String digest = MiscUtil.createStringDigest((String)key.toString());
        File file = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        file = new File(file, ".metadata/.plugins/org.eclipse.sapphire.ui/state");
        file = new File(file, digest);
        return file;
    }

    private final int getLastActivePage() {
        int lastActivePage = 0;
        try {
            Preferences prefs = this.getInstancePreferences(false);
            if (prefs != null) {
                lastActivePage = prefs.getInt(PREFS_LAST_ACTIVE_PAGE, lastActivePage);
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return lastActivePage;
    }

    private final void setLastActivePage(int index) {
        try {
            Preferences prefs = this.getInstancePreferences(true);
            if (prefs != null) {
                prefs.putInt(PREFS_LAST_ACTIVE_PAGE, index);
                prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public final IProject getProject() {
        IFile ifile = this.getFile();
        return ifile == null ? null : ifile.getProject();
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.doSetInput(input);
    }

    protected final void setInput(IEditorInput input) {
        this.doSetInput(input);
        super.setInput(input);
    }

    protected final void setInputWithNotify(IEditorInput input) {
        this.doSetInput(input);
        super.setInputWithNotify(input);
    }

    private void doSetInput(IEditorInput input) {
        this.setPartName(input.getName());
    }

    public int addEditorPage(EditorPart page) throws PartInitException {
        return this.addPage((IEditorPart)page, this.getEditorInput());
    }

    public void addEditorPage(int index, EditorPart page) throws PartInitException {
        this.addPage(index, (IEditorPart)page, this.getEditorInput());
    }

    public int addPage(IEditorPart page, IEditorInput input) throws PartInitException {
        int index = super.addPage(page, input);
        this.setPageText(index, page.getTitle());
        return index;
    }

    public void addPage(int index, IEditorPart page, IEditorInput input) throws PartInitException {
        super.addPage(index, page, input);
        this.setPageText(index, page.getTitle());
    }

    protected final void addPages() {
        if (this.getEditorSite().getActionBarContributor() == null) {
            IActionBars actionBars = this.getEditorSite().getActionBars();
            EditorActionBars editorActionBars = (EditorActionBars)actionBars;
            SapphireEditorActionBarContributor actionBarContributor = new SapphireEditorActionBarContributor();
            actionBarContributor.init(actionBars, this.getSite().getPage());
            editorActionBars.setEditorContributor((IEditorActionBarContributor)actionBarContributor);
        }
        String error = null;
        IFile file = this.getFile();
        if (file != null && !file.isAccessible()) {
            error = Resources.resourceNotAccessible;
        }
        if (error == null) {
            try {
                this.createSourcePages();
                this.model = this.createModel();
            }
            catch (PartInitException e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            if (this.model == null) {
                error = NLS.bind((String)Resources.failedToCreateModel, (Object[])new Object[]{this.getClass().getName()});
                int i = 0;
                int n = this.getPageCount();
                while (i < n) {
                    this.removePage(i);
                    ++i;
                }
            } else {
                try {
                    this.adaptModel(this.model);
                    this.createDiagramPages();
                    this.createFormPages();
                    this.createFileChangeListener();
                }
                catch (PartInitException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
                this.setActivePage(this.getLastActivePage());
            }
        }
        if (error != null) {
            Composite page = new Composite(this.getContainer(), 0);
            page.setLayout((Layout)GridLayoutUtil.glayout(1));
            page.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            SapphireFormText message = new SapphireFormText(page, 0);
            message.setLayoutData(GridLayoutUtil.gd());
            message.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            message.setText(error, false, false);
            this.addPage((Control)page);
            this.setPageText(0, Resources.errorPageTitle);
        }
    }

    protected abstract void createSourcePages() throws PartInitException;

    protected abstract void createFormPages() throws PartInitException;

    protected void createDiagramPages() throws PartInitException {
    }

    public final Object getPage() {
        int pageIndex = this.getActivePage();
        if (pageIndex == -1) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    public final void showPage(Object page) {
        int index = this.pages.indexOf(page);
        this.setActivePage(index);
    }

    public final void showPage(SapphireEditorPagePart editorPagePart) {
        int i = 0;
        int n = this.getPageCount();
        while (i < n) {
            Object page = this.pages.get(i);
            if (page instanceof EditorPagePresentation && ((EditorPagePresentation)page).getPart() == editorPagePart) {
                this.setActivePage(i);
                return;
            }
            ++i;
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        this.setLastActivePage(pageIndex);
        if (this.outline != null && !this.outline.isDisposed()) {
            this.outline.refresh();
        }
        this.refreshPropertiesViewContribution();
        Object page = this.pages.get(pageIndex);
        if (page instanceof SapphireEditorFormPage) {
            ((SapphireEditorFormPage)page).setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.model.resource().save();
        }
        catch (ResourceStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected final void createFileChangeListener() {
        this.fileChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                SapphireEditor.this.handleFileChangedEvent(event);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fileChangeListener, 1);
    }

    protected final void handleFileChangedEvent(IResourceChangeEvent event) {
        IResourceDelta localDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && this.getFile() != null && (localDelta = delta.findMember(this.getFile().getFullPath())) != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (localDelta.getKind() == 2) {
                        SapphireEditor.this.getSite().getPage().closeEditor((IEditorPart)SapphireEditor.this, false);
                    }
                }
            });
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fileChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fileChangeListener);
        }
        this.imageCache.dispose();
        this.actionsManager.dispose();
        if (this.model != null) {
            this.model.dispose();
        }
        if (this.serviceContext != null) {
            this.serviceContext.dispose();
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outline == null || this.outline.isDisposed()) {
                this.outline = new SapphireEditorContentOutline(this);
            }
            return this.outline;
        }
        if (type == IPropertySheetPage.class) {
            if (this.propertiesViewPage == null) {
                this.propertiesViewPage = new SapphirePropertySheetPage();
                this.propertiesViewContributionChangeListener = new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireEditorPagePart.PropertiesViewContributionChangedEvent) {
                            SapphireEditorPagePart.PropertiesViewContributionChangedEvent evt = (SapphireEditorPagePart.PropertiesViewContributionChangedEvent)event;
                            SapphireEditor.this.propertiesViewPage.setPart(evt.contribution());
                        }
                    }
                };
                this.refreshPropertiesViewContribution();
            }
            return this.propertiesViewPage;
        }
        return super.getAdapter(type);
    }

    public final List<SapphireEditorPagePart> getEditorPageParts() {
        ReadOnlyListFactory parts = ReadOnlyListFactory.create();
        for (Object page : this.pages) {
            if (!(page instanceof EditorPagePresentation)) continue;
            parts.add((Object)((EditorPagePresentation)page).getPart());
        }
        return parts.export();
    }

    public final SapphireEditorPagePart getEditorPagePart(String name) {
        for (Object page : this.pages) {
            if (!(page instanceof EditorPagePresentation) || !((String)((EditorPagePresentation)page).getPart().definition().getPageName().getContent()).equalsIgnoreCase(name)) continue;
            return ((EditorPagePresentation)page).getPart();
        }
        return null;
    }

    private void refreshPropertiesViewContribution() {
        if (this.propertiesViewPage != null) {
            for (SapphireEditorPagePart editorPagePart : this.getEditorPageParts()) {
                editorPagePart.detach(this.propertiesViewContributionChangeListener);
            }
            PropertiesViewContributionPart contribution = null;
            Object page = this.getPage();
            if (page instanceof EditorPagePresentation) {
                SapphireEditorPagePart editorPagePart = ((EditorPagePresentation)page).getPart();
                editorPagePart.attach(this.propertiesViewContributionChangeListener);
                contribution = editorPagePart.getPropertiesViewContribution();
            }
            this.propertiesViewPage.setPart(contribution);
        }
    }

    public final IContentOutlinePage getContentOutlineForActivePage() {
        int activePageIndex = this.getActivePage();
        Object page = this.pages.get(activePageIndex);
        return this.getContentOutline(page);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page instanceof MasterDetailsEditorPage) {
            MasterDetailsEditorPage mdpage = (MasterDetailsEditorPage)page;
            return mdpage.getContentOutlinePage();
        }
        if (page instanceof IEditorPart && ((IEditorPart)page).getAdapter(IContentOutlinePage.class) != null) {
            return (IContentOutlinePage)((IEditorPart)page).getAdapter(IContentOutlinePage.class);
        }
        return null;
    }

    @Override
    public ISapphirePart getParentPart() {
        return null;
    }

    @Override
    public <T> T nearest(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.emptySet();
    }

    @Override
    public final String getMainActionContext() {
        return this.actionsManager.getMainActionContext();
    }

    @Override
    public final SapphireActionGroup getActions() {
        return this.actionsManager.getActions();
    }

    @Override
    public final SapphireActionGroup getActions(String context) {
        return this.actionsManager.getActions(context);
    }

    @Override
    public final SapphireAction getAction(String id) {
        return this.actionsManager.getAction(id);
    }

    @Override
    public Status getValidationState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContext getDocumentationContext() {
        return null;
    }

    @Override
    public SapphireImageCache getImageCache() {
        return this.imageCache;
    }

    public void collectAllReferencedProperties(Set<ModelProperty> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A result = null;
        if (adapterType == IEditorPart.class) {
            result = adapterType.cast(this.getActiveEditor());
        }
        if (result == null && adapterType == IEditorSite.class) {
            result = adapterType.cast(this.getEditorSite());
        }
        if (result == null) {
            result = adapterType.cast(this.getAdapter(adapterType));
        }
        if (result == null && this.getParentPart() != null) {
            result = this.getParentPart().adapt(adapterType);
        }
        return result;
    }

    @Override
    public final <S extends Service> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    @Override
    public final <S extends Service> List<S> services(Class<S> serviceType) {
        if (this.serviceContext == null) {
            this.serviceContext = new PartServiceContext(this);
        }
        return this.serviceContext.services(serviceType);
    }

    private static final class Resources
    extends NLS {
        public static String resourceNotAccessible;
        public static String failedToCreateModel;
        public static String errorPageTitle;

        static {
            Resources.initializeMessages((String)SapphireEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static class SapphireEditorActionBarContributor
    extends MultiPageEditorActionBarContributor {
        private MultiPageEditorPart multiPageEditor = null;

        private SapphireEditorActionBarContributor() {
        }

        public void setActiveEditor(IEditorPart targetEditor) {
            if (targetEditor instanceof MultiPageEditorPart) {
                this.multiPageEditor = (MultiPageEditorPart)targetEditor;
            }
            super.setActiveEditor(targetEditor);
        }

        public void setActivePage(IEditorPart activeEditor) {
            IActionBars actionBars;
            ISapphireEditorActionContributor actionContributor = null;
            ITextEditor textEditor = null;
            if (this.multiPageEditor != null) {
                Object obj;
                if (activeEditor instanceof ISapphireEditorActionContributor) {
                    actionContributor = (ISapphireEditorActionContributor)activeEditor;
                } else if (activeEditor instanceof ITextEditor) {
                    textEditor = (ITextEditor)activeEditor;
                } else if (activeEditor == null && (obj = this.multiPageEditor.getSelectedPage()) instanceof ISapphireEditorActionContributor) {
                    actionContributor = (ISapphireEditorActionContributor)obj;
                }
            }
            if ((actionBars = this.getActionBars()) != null && (actionContributor != null || textEditor != null)) {
                if (actionContributor != null) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), actionContributor.getAction(ActionFactory.DELETE.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), actionContributor.getAction(ActionFactory.SELECT_ALL.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), actionContributor.getAction(ActionFactory.PRINT.getId()));
                } else if (textEditor != null) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), textEditor.getAction(ActionFactory.DELETE.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), textEditor.getAction(ActionFactory.SELECT_ALL.getId()));
                    actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), textEditor.getAction(ActionFactory.PRINT.getId()));
                }
                actionBars.updateActionBars();
            }
        }
    }
}

