/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ClassLocator;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceLocator;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.def.ActionDef;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.ISapphireUiExtensionDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireExtensionSystem {
    private static List<ISapphireUiExtensionDef> extensions;
    private static List<ActionDef> actions;
    private static List<ActionHandlerDef> actionHandlers;
    private static List<ActionHandlerFactoryDef> actionHandlerFactories;

    public static synchronized List<ISapphireUiExtensionDef> getExtensions() {
        if (extensions == null) {
            ArrayList<ISapphireUiExtensionDef> list = new ArrayList<ISapphireUiExtensionDef>();
            for (final ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                final ResourceLocator resourceLocator = new ResourceLocator(){

                    public URL find(String name) {
                        return handle.findResource(name);
                    }
                };
                final ClassLocator classLocator = new ClassLocator(){

                    public Class<?> find(String name) {
                        return handle.findClass(name);
                    }
                };
                try {
                    UrlResourceStore store = new UrlResourceStore(handle.extension()){

                        public <A> A adapt(Class<A> adapterType) {
                            if (adapterType == ClassLocator.class) {
                                return adapterType.cast(classLocator);
                            }
                            if (adapterType == ResourceLocator.class) {
                                return adapterType.cast(resourceLocator);
                            }
                            return (A)super.adapt(adapterType);
                        }
                    };
                    XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)store);
                    RootXmlResource resource = new RootXmlResource(xmlResourceStore);
                    ISapphireUiExtensionDef extension = (ISapphireUiExtensionDef)ISapphireUiExtensionDef.TYPE.instantiate((Resource)resource);
                    list.add(extension);
                }
                catch (ResourceStoreException e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            extensions = Collections.unmodifiableList(list);
        }
        return extensions;
    }

    public static synchronized List<ActionDef> getActions() {
        if (actions == null) {
            ArrayList<ActionDef> list = new ArrayList<ActionDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ActionDef def : extension.getActions()) {
                    list.add(def);
                }
            }
            actions = Collections.unmodifiableList(list);
        }
        return actions;
    }

    public static synchronized List<ActionHandlerDef> getActionHandlers() {
        if (actionHandlers == null) {
            ArrayList<ActionHandlerDef> list = new ArrayList<ActionHandlerDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ActionHandlerDef def : extension.getActionHandlers()) {
                    list.add(def);
                }
            }
            actionHandlers = Collections.unmodifiableList(list);
        }
        return actionHandlers;
    }

    public static synchronized List<ActionHandlerFactoryDef> getActionHandlerFactories() {
        if (actionHandlerFactories == null) {
            ArrayList<ActionHandlerFactoryDef> list = new ArrayList<ActionHandlerFactoryDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ActionHandlerFactoryDef def : extension.getActionHandlerFactories()) {
                    list.add(def);
                }
            }
            actionHandlerFactories = Collections.unmodifiableList(list);
        }
        return actionHandlerFactories;
    }
}

