/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.ui.def.ISapphireHint;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.def.internal.SapphireHintValueDefaultValueService;

public final class SapphirePartDefMethods {
    public static String getHint(PartDef def, String hintName) {
        String hintValue = null;
        for (ISapphireHint hint : def.getHints()) {
            if (!hintName.equals(hint.getName().getText())) continue;
            hintValue = hint.getValue().getText();
            break;
        }
        if (hintValue == null) {
            hintValue = SapphireHintValueDefaultValueService.getDefaultValue(hintName);
        }
        return hintValue;
    }

    public static String getHint(PartDef def, String hintName, String defaultValue) {
        String hintValueStr = SapphirePartDefMethods.getHint(def, hintName);
        return hintValueStr == null ? defaultValue : hintValueStr;
    }

    public static boolean getHint(PartDef def, String hintName, boolean defaultValue) {
        String hintValueStr = SapphirePartDefMethods.getHint(def, hintName);
        if (hintValueStr != null) {
            return Boolean.parseBoolean(hintValueStr);
        }
        return defaultValue;
    }

    public static int getHint(PartDef def, String hintName, int defaultValue) {
        String hintValueStr = SapphirePartDefMethods.getHint(def, hintName);
        if (hintValueStr != null) {
            try {
                return Integer.parseInt(hintValueStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }
}

