/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramLabelDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionBendPoints;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.ModelUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramConnectionPart
extends SapphirePart
implements IPropertiesViewContributorPart {
    protected DiagramConnectionTemplate connectionTemplate;
    protected IDiagramExplicitConnectionBindingDef bindingDef;
    protected IDiagramConnectionDef definition;
    protected IModelElement modelElement;
    private ModelPath endpoint1Path;
    private ModelPath endpoint2Path;
    private IDiagramConnectionEndpointBindingDef endpoint1Def;
    private IDiagramConnectionEndpointBindingDef endpoint2Def;
    private IModelElement srcNodeModel;
    private IModelElement targetNodeModel;
    private Listener endpointModelListener;
    private FunctionResult endpoint1FunctionResult;
    private FunctionResult endpoint2FunctionResult;
    private ModelProperty endpoint1Property;
    private ModelProperty endpoint2Property;
    protected FunctionResult labelFunctionResult;
    protected ValueProperty labelProperty;
    protected FunctionResult idFunctionResult;
    protected Listener modelPropertyListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private DiagramConnectionBendPoints bendPoints = new DiagramConnectionBendPoints();
    private Point labelPosition;

    public DiagramConnectionPart() {
    }

    public DiagramConnectionPart(IDiagramExplicitConnectionBindingDef bindingDef, ModelPath endpoint1Path, ModelPath endpoint2Path) {
        this.bindingDef = bindingDef;
        this.endpoint1Path = endpoint1Path;
        this.endpoint2Path = endpoint2Path;
    }

    protected void initLabelId() {
        this.connectionTemplate = (DiagramConnectionTemplate)this.getParentPart();
        this.definition = (IDiagramConnectionDef)((SapphirePart)this).definition;
        this.modelElement = this.getModelElement();
        IDiagramLabelDef labelDef = (IDiagramLabelDef)this.bindingDef.getLabel().element();
        if (labelDef != null) {
            this.labelFunctionResult = this.initExpression(this.modelElement, (Function)labelDef.getText().getContent(), String.class, null, new Runnable(){

                public void run() {
                    DiagramConnectionPart.this.refreshLabel();
                }
            });
            this.labelProperty = FunctionUtil.getFunctionProperty(this.modelElement, this.labelFunctionResult);
        }
        this.idFunctionResult = this.initExpression(this.modelElement, (Function)this.bindingDef.getInstanceId().getContent(), String.class, null, new Runnable(){

            public void run() {
            }
        });
    }

    @Override
    protected void init() {
        this.initLabelId();
        this.endpointModelListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramConnectionPart.this.handlEndpointModelPropertyChange(event);
            }
        };
        this.endpoint1Def = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint1().element();
        this.srcNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
        if (this.srcNodeModel != null) {
            this.endpoint1FunctionResult = this.initExpression(this.srcNodeModel, (Function)this.endpoint1Def.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
        this.endpoint2Def = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        this.targetNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path);
        if (this.targetNodeModel != null) {
            this.endpoint2FunctionResult = this.initExpression(this.targetNodeModel, (Function)this.endpoint2Def.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
        this.endpoint1Property = ModelUtil.resolve(this.modelElement, this.endpoint1Path);
        this.endpoint2Property = ModelUtil.resolve(this.modelElement, this.endpoint2Path);
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramConnectionPart.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    public DiagramConnectionTemplate getDiagramConnectionTemplate() {
        return this.connectionTemplate;
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public IModelElement getEndpoint1() {
        return this.srcNodeModel;
    }

    public IModelElement getEndpoint2() {
        return this.targetNodeModel;
    }

    public boolean canEditLabel() {
        return this.labelProperty != null;
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        return label;
    }

    public void setLabel(String newValue) {
        if (this.labelProperty != null) {
            this.modelElement.write(this.labelProperty, (Object)newValue);
        }
    }

    public IDiagramConnectionDef getConnectionDef() {
        return this.definition;
    }

    public void refreshLabel() {
        this.notifyConnectionUpdate();
    }

    public String getConnectionTypeId() {
        return (String)this.definition.getId().getContent();
    }

    public String getInstanceId() {
        String id = null;
        if (this.idFunctionResult != null) {
            id = (String)this.idFunctionResult.value();
        }
        return id;
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Connection");
        contextSet.add("Sapphire.Diagram.Connection.Hidden");
        return contextSet;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.idFunctionResult != null) {
            this.idFunctionResult.dispose();
        }
        if (this.endpoint1FunctionResult != null) {
            this.endpoint1FunctionResult.dispose();
        }
        if (this.endpoint2FunctionResult != null) {
            this.endpoint2FunctionResult.dispose();
        }
        this.removeModelListener();
    }

    public void resetEndpoint1() {
        if (this.endpoint1FunctionResult != null) {
            SapphireDiagramEditorPagePart diagramPart;
            DiagramNodePart nodePart;
            String value = (String)this.endpoint1FunctionResult.value();
            if ((value == null || value.length() == 0) && (nodePart = (diagramPart = this.getDiagramConnectionTemplate().getDiagramEditor()).getDiagramNodePart(this.srcNodeModel)) != null) {
                value = IdUtil.computeNodeId(nodePart);
            }
            this.setModelProperty(this.modelElement, this.endpoint1Path, (Object)value);
        }
    }

    public void resetEndpoint2() {
        if (this.endpoint2FunctionResult != null) {
            SapphireDiagramEditorPagePart diagramPart;
            DiagramNodePart nodePart;
            String value = (String)this.endpoint2FunctionResult.value();
            if ((value == null || value.length() == 0) && (nodePart = (diagramPart = this.getDiagramConnectionTemplate().getDiagramEditor()).getDiagramNodePart(this.targetNodeModel)) != null) {
                value = IdUtil.computeNodeId(nodePart);
            }
            this.setModelProperty(this.modelElement, this.endpoint2Path, (Object)value);
        }
    }

    public void resetEndpoint1(DiagramNodePart newSrcNode) {
        this.srcNodeModel = newSrcNode.getLocalModelElement();
        String endpoint1Value = this.connectionTemplate.getSerializedEndpoint1(newSrcNode);
        this.connectionTemplate.setSerializedEndpoint1(this.modelElement, endpoint1Value);
    }

    public void resetEndpoint2(DiagramNodePart newTargetNode) {
        this.targetNodeModel = newTargetNode.getLocalModelElement();
        String endpoint2Value = this.connectionTemplate.getSerializedEndpoint2(newTargetNode);
        this.connectionTemplate.setSerializedEndpoint2(this.modelElement, endpoint2Value);
    }

    protected IModelElement resolveEndpoint(IModelElement modelElement, ModelPath endpointPath) {
        if (endpointPath.length() == 1) {
            SapphireDiagramEditorPagePart diagramEditorPart;
            DiagramNodePart targetNode;
            String propertyName = ((ModelPath.PropertySegment)endpointPath.head()).getPropertyName();
            ModelProperty modelProperty = this.resolve(modelElement, propertyName);
            if (!(modelProperty instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            ValueProperty property = (ValueProperty)modelProperty;
            Value valObj = modelElement.read(property);
            if (!(valObj instanceof ReferenceValue)) {
                throw new RuntimeException("Property " + propertyName + " value not a reference");
            }
            ReferenceValue refVal = (ReferenceValue)valObj;
            Object targetObj = refVal.resolve();
            if (targetObj == null && refVal.getText() != null && (targetNode = IdUtil.getNodePart(diagramEditorPart = this.getDiagramConnectionTemplate().getDiagramEditor(), refVal.getText())) != null) {
                targetObj = targetNode.getLocalModelElement();
            }
            return (IModelElement)targetObj;
        }
        ModelPath.Segment head = endpointPath.head();
        if (head instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = modelElement.parent();
            if (parent == null) {
                throw new RuntimeException("Invalid model path: " + endpointPath);
            }
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            return this.resolveEndpoint((IModelElement)parent, endpointPath.tail());
        }
        throw new RuntimeException("Invalid model path: " + endpointPath);
    }

    protected void setModelProperty(IModelElement modelElement, String propertyName, Object value) {
        if (propertyName != null) {
            ModelElementType type = modelElement.type();
            ModelProperty property = type.property(propertyName);
            if (property == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            if (!(property instanceof ValueProperty)) {
                throw new RuntimeException("Property " + propertyName + " not a ValueProperty");
            }
            modelElement.write((ValueProperty)property, value);
        }
    }

    protected void setModelProperty(IModelElement modelElement, ModelPath propertyPath, Object value) {
        if (propertyPath.length() == 1) {
            String propertyName = ((ModelPath.PropertySegment)propertyPath.head()).getPropertyName();
            this.setModelProperty(modelElement, propertyName, value);
        } else if (propertyPath.head() instanceof ModelPath.ParentElementSegment) {
            IModelParticle parent = modelElement.parent();
            if (parent instanceof ModelElementList) {
                parent = parent.parent();
            }
            this.setModelProperty((IModelElement)parent, propertyPath.tail(), value);
        }
    }

    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, this.endpoint1Path);
        this.modelElement.attach(this.modelPropertyListener, this.endpoint2Path);
        if (this.srcNodeModel != null) {
            this.srcNodeModel.attach(this.endpointModelListener);
        }
        if (this.targetNodeModel != null) {
            this.targetNodeModel.attach(this.endpointModelListener);
        }
    }

    public void removeModelListener() {
        this.modelElement.detach(this.modelPropertyListener, this.endpoint1Path);
        this.modelElement.detach(this.modelPropertyListener, this.endpoint2Path);
        if (this.srcNodeModel != null) {
            this.srcNodeModel.detach(this.endpointModelListener);
        }
        if (this.targetNodeModel != null) {
            this.targetNodeModel.detach(this.endpointModelListener);
        }
    }

    protected void handlEndpointModelPropertyChange(PropertyEvent event) {
        IModelElement newTargetModel;
        boolean endpointChanged = false;
        boolean sourceChange = false;
        if (this.srcNodeModel == null || event.element() == this.srcNodeModel) {
            IModelElement newSrcModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
            if (newSrcModel != this.srcNodeModel) {
                endpointChanged = true;
                sourceChange = true;
            }
        } else if ((this.targetNodeModel == null || event.element() == this.targetNodeModel) && (newTargetModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path)) != this.targetNodeModel) {
            endpointChanged = true;
        }
        if (endpointChanged) {
            this.handleEndpointChange(sourceChange);
            this.notifyConnectionEndpointUpdate();
        }
    }

    protected void handleModelPropertyChange(PropertyEvent event) {
        ModelProperty property = event.property();
        if (property.getName().equals(this.endpoint1Property.getName()) || property.getName().equals(this.endpoint2Property.getName())) {
            boolean sourceChange = property.getName().equals(this.endpoint1Property.getName());
            this.handleEndpointChange(sourceChange);
            this.notifyConnectionEndpointUpdate();
        }
    }

    private void handleEndpointChange(boolean sourceChange) {
        if (sourceChange) {
            this.srcNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint1Path);
            if (this.endpoint1FunctionResult != null) {
                this.endpoint1FunctionResult.dispose();
                this.endpoint1FunctionResult = null;
            }
            if (this.srcNodeModel != null) {
                this.endpoint1FunctionResult = this.initExpression(this.srcNodeModel, (Function)this.endpoint1Def.getValue().getContent(), String.class, null, new Runnable(){

                    public void run() {
                    }
                });
            }
        } else {
            this.targetNodeModel = this.resolveEndpoint(this.modelElement, this.endpoint2Path);
            if (this.endpoint2FunctionResult != null) {
                this.endpoint2FunctionResult.dispose();
                this.endpoint2FunctionResult = null;
            }
            if (this.targetNodeModel != null) {
                this.endpoint2FunctionResult = this.initExpression(this.targetNodeModel, (Function)this.endpoint2Def.getValue().getContent(), String.class, null, new Runnable(){

                    public void run() {
                    }
                });
            }
        }
    }

    protected void notifyConnectionUpdate() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionUpdateEvent(cue);
        }
    }

    protected void notifyConnectionEndpointUpdate() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionEndpointEvent(cue);
        }
    }

    protected void notifyAddBendpoint() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent event = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionAddBendpointEvent(event);
        }
    }

    protected void notifyRemoveBendpoint() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionRemoveBendpointEvent(cue);
        }
    }

    protected void notifyMoveBendpoint() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionMoveBendpointEvent(cue);
        }
    }

    protected void notifyResetBendpoints() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent event = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionResetBendpointsEvent(event);
        }
    }

    protected void notifyMoveConnectionLabel() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramConnectionEvent cue = new DiagramConnectionEvent(this);
            ((SapphireDiagramPartListener)listener).handleConnectionMoveLabelEvent(cue);
        }
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement(), this.bindingDef);
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    public void addBendpoint(int index, int x, int y) {
        this.bendPoints.getBendPoints().add(index, new Point(x, y));
        this.notifyAddBendpoint();
    }

    public void removeBendpoint(int index) {
        this.bendPoints.getBendPoints().remove(index);
        this.notifyRemoveBendpoint();
    }

    public void removeAllBendpoints() {
        this.bendPoints.getBendPoints().clear();
        this.notifyRemoveBendpoint();
    }

    public void updateBendpoint(int index, int x, int y) {
        if (index < this.bendPoints.getBendPoints().size()) {
            this.bendPoints.getBendPoints().set(index, new Point(x, y));
        }
        this.notifyMoveBendpoint();
    }

    public void resetBendpoints(DiagramConnectionBendPoints bendPoints) {
        this.resetBendpoints(bendPoints.getBendPoints(), bendPoints.isAutoLayout(), bendPoints.isDefault());
    }

    public void resetBendpoints(List<Point> bendpoints, boolean autoLayout, boolean isDefault) {
        boolean changed = false;
        if (bendpoints.size() != this.bendPoints.getBendPoints().size() || autoLayout != this.bendPoints.isAutoLayout() || isDefault != this.bendPoints.isDefault()) {
            changed = true;
        } else {
            int i = 0;
            while (i < bendpoints.size()) {
                Point newPt = bendpoints.get(i);
                Point oldPt = this.bendPoints.getBendPoints().get(i);
                if (newPt.getX() != oldPt.getX() || newPt.getY() != oldPt.getY()) {
                    changed = true;
                    break;
                }
                ++i;
            }
        }
        if (changed) {
            this.bendPoints.setBendPoints(bendpoints);
            this.bendPoints.setDefault(isDefault);
            this.bendPoints.setAutoLayout(autoLayout);
            this.notifyResetBendpoints();
        }
    }

    public DiagramConnectionBendPoints getConnectionBendpoints() {
        return new DiagramConnectionBendPoints(this.bendPoints);
    }

    public Point getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point newPos) {
        boolean changed = false;
        if (this.labelPosition == null && newPos != null) {
            this.labelPosition = new Point(newPos);
            changed = true;
        } else if (this.labelPosition != null && newPos == null) {
            this.labelPosition = null;
            changed = true;
        } else if (this.labelPosition != null && newPos != null && !this.labelPosition.equals(newPos)) {
            this.labelPosition.setX(newPos.getX());
            this.labelPosition.setY(newPos.getY());
            changed = true;
        }
        if (changed) {
            this.notifyMoveConnectionLabel();
        }
    }
}

