/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.IPropertiesViewContributorPart;
import org.eclipse.sapphire.ui.PropertiesViewContributionManager;
import org.eclipse.sapphire.ui.PropertiesViewContributionPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImageDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramLabelDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeImageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeProblemDecoratorDef;
import org.eclipse.sapphire.ui.diagram.def.ImagePlacement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramPartListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNodePart
extends SapphirePart
implements IPropertiesViewContributorPart {
    private static final String DEFAULT_ACTION_ID = "Sapphire.Diagram.Node.Default";
    private DiagramNodeTemplate nodeTemplate;
    private IDiagramNodeDef definition;
    private IModelElement modelElement;
    private FunctionResult labelFunctionResult;
    private FunctionResult idFunctionResult;
    private FunctionResult imageDataFunctionResult;
    private List<FunctionResult> imageDecoratorFunctionResults;
    private List<FunctionResult> imageDecoratorDataFunctionResults;
    private ValueProperty labelProperty;
    private SapphireAction defaultAction;
    private SapphireActionHandler defaultActionHandler;
    private Listener modelPropertyListener;
    private FilteredListener<ElementValidationEvent> elementValidationListener;
    private PropertiesViewContributionManager propertiesViewContributionManager;
    private DiagramNodeBounds nodeBounds = new DiagramNodeBounds();

    @Override
    protected void init() {
        FunctionResult imageResult;
        super.init();
        this.nodeTemplate = (DiagramNodeTemplate)this.getParentPart();
        this.definition = (IDiagramNodeDef)((SapphirePart)this).definition;
        this.modelElement = this.getModelElement();
        this.labelFunctionResult = this.initExpression(this.modelElement, (Function)((IDiagramLabelDef)this.definition.getLabel().element()).getText().getContent(), String.class, null, new Runnable(){

            public void run() {
                DiagramNodePart.this.refreshLabel();
            }
        });
        this.labelProperty = FunctionUtil.getFunctionProperty(this.modelElement, this.labelFunctionResult);
        this.idFunctionResult = this.initExpression(this.modelElement, (Function)this.definition.getInstanceId().getContent(), String.class, null, new Runnable(){

            public void run() {
            }
        });
        if (this.definition.getImage().element() != null) {
            this.imageDataFunctionResult = this.initExpression(this.modelElement, (Function)((IDiagramNodeImageDef)this.definition.getImage().element()).getImage().getContent(), ImageData.class, null, new Runnable(){

                public void run() {
                    DiagramNodePart.this.refreshImage();
                }
            });
        }
        ModelElementList<IDiagramImageDecoratorDef> imageDecorators = this.definition.getImageDecorators();
        this.imageDecoratorFunctionResults = new ArrayList<FunctionResult>();
        for (IDiagramImageDecoratorDef imageDecorator : imageDecorators) {
            imageResult = this.initExpression(this.modelElement, (Function)imageDecorator.getVisibleWhen().getContent(), String.class, null, new Runnable(){

                public void run() {
                    DiagramNodePart.this.refreshDecorator();
                }
            });
            this.imageDecoratorFunctionResults.add(imageResult);
        }
        this.imageDecoratorDataFunctionResults = new ArrayList<FunctionResult>();
        for (IDiagramImageDecoratorDef imageDecorator : imageDecorators) {
            imageResult = this.initExpression(this.modelElement, (Function)imageDecorator.getImage().getContent(), ImageData.class, null, new Runnable(){

                public void run() {
                    DiagramNodePart.this.refreshDecorator();
                }
            });
            this.imageDecoratorDataFunctionResults.add(imageResult);
        }
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramNodePart.this.notifyNodeUpdate();
            }
        };
        this.modelElement.attach(this.modelPropertyListener, "*");
        this.elementValidationListener = new FilteredListener<ElementValidationEvent>(){

            protected void handleTypedEvent(ElementValidationEvent event) {
                DiagramNodePart.this.notifyNodeUpdate();
            }
        };
        this.modelElement.attach(this.elementValidationListener);
    }

    public DiagramNodeTemplate getDiagramNodeTemplate() {
        return this.nodeTemplate;
    }

    @Override
    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public List<NodeImageDecorator> getImageDecorators() {
        ArrayList<NodeImageDecorator> imageDecorators = new ArrayList<NodeImageDecorator>();
        ModelElementList<IDiagramImageDecoratorDef> defs = this.definition.getImageDecorators();
        int i = 0;
        while (i < this.imageDecoratorFunctionResults.size()) {
            String show;
            FunctionResult result = this.imageDecoratorFunctionResults.get(i);
            if (result != null && (show = (String)result.value()) != null && show.equals("true")) {
                IDiagramImageDecoratorDef def = (IDiagramImageDecoratorDef)defs.get(i);
                FunctionResult imageDataResult = this.imageDecoratorDataFunctionResults.get(i);
                NodeImageDecorator nodeImageDecorator = new NodeImageDecorator((ImageData)imageDataResult.value(), def);
                imageDecorators.add(nodeImageDecorator);
            }
            ++i;
        }
        return imageDecorators;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contextSet = new HashSet<String>();
        contextSet.add("Sapphire.Diagram.Node");
        contextSet.add("Sapphire.Diagram.Node.Hidden");
        return contextSet;
    }

    public SapphireActionHandler getDefaultActionHandler() {
        if (this.defaultAction == null) {
            this.defaultAction = this.getAction(DEFAULT_ACTION_ID);
            this.defaultActionHandler = this.defaultAction.getFirstActiveHandler();
        }
        return this.defaultActionHandler;
    }

    @Override
    public void dispose() {
        FunctionResult result;
        super.dispose();
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        if (this.idFunctionResult != null) {
            this.idFunctionResult.dispose();
        }
        if (this.imageDataFunctionResult != null) {
            this.imageDataFunctionResult.dispose();
        }
        int i = 0;
        while (i < this.imageDecoratorFunctionResults.size()) {
            result = this.imageDecoratorFunctionResults.get(i);
            if (result != null) {
                result.dispose();
            }
            ++i;
        }
        i = 0;
        while (i < this.imageDecoratorDataFunctionResults.size()) {
            result = this.imageDecoratorDataFunctionResults.get(i);
            if (result != null) {
                result.dispose();
            }
            ++i;
        }
        this.modelElement.detach(this.modelPropertyListener, "*");
        this.modelElement.detach(this.elementValidationListener);
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        }
        return label;
    }

    public void setLabel(String newValue) {
        if (this.labelProperty != null) {
            this.modelElement.write(this.labelProperty, (Object)newValue);
        }
    }

    public void refreshLabel() {
        this.notifyNodeUpdate();
    }

    public void refreshImage() {
        this.notifyNodeUpdate();
    }

    public void refreshDecorator() {
        this.notifyNodeUpdate();
    }

    public boolean canEditLabel() {
        return this.labelProperty != null;
    }

    public String getNodeTypeId() {
        return (String)this.definition.getId().getContent();
    }

    public String getInstanceId() {
        String id = null;
        if (this.idFunctionResult != null) {
            id = (String)this.idFunctionResult.value();
        }
        return id;
    }

    public boolean canResizeShape() {
        return (Boolean)this.definition.isResizable().getContent();
    }

    public DiagramNodeBounds getNodeBounds() {
        return new DiagramNodeBounds(this.nodeBounds);
    }

    public void setNodeBounds(int x, int y) {
        this.setNodeBounds(new DiagramNodeBounds(x, y, -1, -1, false, false));
    }

    public void setNodeBounds(int x, int y, boolean autoLayout, boolean defaultPosition) {
        this.setNodeBounds(new DiagramNodeBounds(x, y, -1, -1, autoLayout, defaultPosition));
    }

    public void setNodeBounds(Bounds bounds) {
        DiagramNodeBounds nodeBounds = new DiagramNodeBounds(bounds);
        this.setNodeBounds(nodeBounds);
    }

    public void setNodeBounds(DiagramNodeBounds bounds) {
        if (!this.nodeBounds.equals(bounds)) {
            this.nodeBounds.setX(bounds.getX());
            this.nodeBounds.setY(bounds.getY());
            this.nodeBounds.setAutoLayout(bounds.isAutoLayout());
            this.nodeBounds.setDefaultPosition(bounds.isDefaultPosition());
            this.notifyNodeMove();
        }
    }

    public int getHorizontalSpacing() {
        if (this.definition.getHorizontalSpacing().getContent() != null) {
            return (Integer)this.definition.getHorizontalSpacing().getContent();
        }
        return 0;
    }

    public int getVerticalSpacing() {
        if (this.definition.getVerticalSpacing().getContent() != null) {
            return (Integer)this.definition.getVerticalSpacing().getContent();
        }
        return 0;
    }

    public ImageData getImage() {
        if (this.imageDataFunctionResult != null) {
            return (ImageData)this.imageDataFunctionResult.value();
        }
        return null;
    }

    public ImagePlacement getImagePlacement() {
        if (this.definition.getImage().element() != null) {
            return (ImagePlacement)((Object)((IDiagramNodeImageDef)this.definition.getImage().element()).getPlacement().getContent());
        }
        return null;
    }

    public int getImageWidth() {
        if (this.definition.getImage().element() != null && ((IDiagramNodeImageDef)this.definition.getImage().element()).getWidth().getContent() != null) {
            ((IDiagramNodeImageDef)this.definition.getImage().element()).getWidth().getContent();
        }
        return 0;
    }

    public int getImageHeight() {
        if (this.definition.getImage().element() != null && ((IDiagramNodeImageDef)this.definition.getImage().element()).getHeight().getContent() != null) {
            ((IDiagramNodeImageDef)this.definition.getImage().element()).getHeight().getContent();
        }
        return 0;
    }

    public int getLabelWidth() {
        if (((IDiagramLabelDef)this.definition.getLabel().element()).getWidth().getContent() != null) {
            return (Integer)((IDiagramLabelDef)this.definition.getLabel().element()).getWidth().getContent();
        }
        return 0;
    }

    public int getLabelHeight() {
        if (((IDiagramLabelDef)this.definition.getLabel().element()).getHeight().getContent() != null) {
            return (Integer)((IDiagramLabelDef)this.definition.getLabel().element()).getHeight().getContent();
        }
        return 0;
    }

    public IDiagramNodeProblemDecoratorDef getProblemIndicatorDef() {
        return this.definition.getProblemDecorator();
    }

    private void notifyNodeUpdate() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent nue = new DiagramNodeEvent(this);
            ((SapphireDiagramPartListener)listener).handleNodeUpdateEvent(nue);
        }
    }

    private void notifyNodeMove() {
        Set<SapphirePartListener> listeners = this.getListeners();
        for (SapphirePartListener listener : listeners) {
            if (!(listener instanceof SapphireDiagramPartListener)) continue;
            DiagramNodeEvent ne = new DiagramNodeEvent(this);
            ((SapphireDiagramPartListener)listener).handleNodeMoveEvent(ne);
        }
    }

    @Override
    public PropertiesViewContributionPart getPropertiesViewContribution() {
        if (this.propertiesViewContributionManager == null) {
            this.propertiesViewContributionManager = new PropertiesViewContributionManager(this, this.getLocalModelElement());
        }
        return this.propertiesViewContributionManager.getPropertiesViewContribution();
    }

    public static final class NodeImageDecorator {
        ImageData imageData;
        IDiagramImageDecoratorDef imageDecoratorDef;

        public NodeImageDecorator(ImageData imageData, IDiagramImageDecoratorDef imageDecoratorDef) {
            this.imageData = imageData;
            this.imageDecoratorDef = imageDecoratorDef;
        }

        public ImageData getImageData() {
            return this.imageData;
        }

        public IDiagramImageDecoratorDef getImageDecoratorDef() {
            return this.imageDecoratorDef;
        }
    }
}

