/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.layout;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class ConnectionHashKey {
    private String nodeId;
    private String connectionId;

    private ConnectionHashKey(String nodeId, String connectionId) {
        this.nodeId = nodeId;
        this.connectionId = connectionId;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof ConnectionHashKey) {
            ConnectionHashKey hashKey = (ConnectionHashKey)object;
            String nodeId = hashKey.getNodeId();
            String connectionId = hashKey.getConnectionId();
            boolean nodeIdEqual = nodeId == null && this.nodeId == null || nodeId != null && this.nodeId != null && nodeId.equals(this.nodeId);
            boolean connIdEqual = connectionId.equals(this.connectionId);
            isEqual = nodeIdEqual && connIdEqual;
        }
        return isEqual;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int hashCode() {
        if (this.nodeId != null) {
            return this.nodeId.hashCode() ^ this.connectionId.hashCode();
        }
        return this.connectionId.hashCode();
    }

    public static ConnectionHashKey createKey(DiagramConnectionPart connPart) {
        SapphireDiagramEditorPagePart diagramPart = connPart.getDiagramConnectionTemplate().getDiagramEditor();
        String connId = IdUtil.computeConnectionId(connPart);
        String nodeId = null;
        if (connPart instanceof DiagramEmbeddedConnectionPart) {
            IModelElement srcElement = connPart.getEndpoint1();
            DiagramNodePart nodePart = diagramPart.getDiagramNodePart(srcElement);
            nodeId = IdUtil.computeNodeId(nodePart);
        }
        ConnectionHashKey hashKey = new ConnectionHashKey(nodeId, connId);
        return hashKey;
    }

    public static ConnectionHashKey createKey(String nodeId, String connId) {
        return new ConnectionHashKey(nodeId, connId);
    }
}

