/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.services.ContentProposalService;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionSystem;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.TextFieldBinding;
import org.eclipse.sapphire.ui.listeners.ValuePropertyEditorListener;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.TextOverlayPainter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class DefaultValuePropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Text textField;
    private static final String CONTENT_ASSIST_KEY_STROKE_STRING = "Ctrl+Space";
    private static final KeyStroke CONTENT_ASSIST_KEY_STROKE;

    static {
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)CONTENT_ASSIST_KEY_STROKE_STRING);
        }
        catch (ParseException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        CONTENT_ASSIST_KEY_STROKE = keyStroke;
    }

    public DefaultValuePropertyEditorRenderer(SapphireRenderingContext context, PropertyEditorPart part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        this.createContents(parent, false);
    }

    protected Control createContents(Composite parent, final boolean suppressBrowseAction) {
        ContentProposalService contentProposalService;
        PropertyEditorPart part = this.getPart();
        final IModelElement element = part.getLocalModelElement();
        ValueProperty property = (ValueProperty)part.getProperty();
        final boolean isLongString = property.hasAnnotation(LongString.class);
        boolean isDeprecated = property.hasAnnotation(Deprecated.class);
        final boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        final boolean isSensitiveData = property.hasAnnotation(SensitiveData.class);
        SapphireActionGroup actions = this.getActions();
        final SapphireActionHandler jumpActionHandler = actions.getAction("Sapphire.Jump").getFirstActiveHandler();
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(this.getActionPresentationManager());
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Assist"));
        toolBarActionsPresentation.addFilter(SapphireActionSystem.createFilterByActionId("Sapphire.Jump"));
        actions.addFilter(new SapphireActionHandlerFilter(){

            public boolean check(SapphireActionHandler handler) {
                String actionId = handler.getAction().getId();
                return !actionId.equals("Sapphire.Browse") || !isReadOnly && !suppressBrowseAction;
            }
        });
        boolean isActionsToolBarNeeded = toolBarActionsPresentation.hasActions();
        boolean isBrowseOnly = part.getRenderingHint("browse.only", false);
        Composite textFieldParent = this.createMainComposite(parent, new PropertyEditorRenderer.CreateMainCompositeDelegate(this, part){

            public boolean canScaleVertically() {
                return isLongString;
            }
        });
        this.context.adapt((Control)textFieldParent);
        this.addControl((Control)textFieldParent);
        int textFieldParentColumns = 1;
        if (isActionsToolBarNeeded) {
            ++textFieldParentColumns;
        }
        if (isDeprecated) {
            ++textFieldParentColumns;
        }
        textFieldParent.setLayout((Layout)GridLayoutUtil.glayout(textFieldParentColumns, 0, 0, 0, 0));
        Composite nestedComposite = new Composite(textFieldParent, 0);
        nestedComposite.setLayoutData((Object)(isLongString ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000)));
        nestedComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        this.context.adapt((Control)nestedComposite);
        this.addControl((Control)nestedComposite);
        PropertyEditorAssistDecorator decorator = this.createDecorator(nestedComposite);
        decorator.control().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        decorator.addEditorControl((Control)nestedComposite);
        int style = 0x800 | (isLongString ? 578 : 0) | (isReadOnly || isBrowseOnly ? 8 : 0) | (isSensitiveData ? 0x400000 : 0);
        this.textField = new Text(nestedComposite, style);
        this.textField.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.context.adapt((Control)this.textField);
        decorator.addEditorControl((Control)this.textField, true);
        TextOverlayPainter.Controller textOverlayPainterController = new TextOverlayPainter.Controller(){

            public boolean isHyperlinkEnabled() {
                return jumpActionHandler == null ? false : jumpActionHandler.isEnabled();
            }

            public void handleHyperlinkEvent() {
                if (jumpActionHandler != null) {
                    jumpActionHandler.execute(DefaultValuePropertyEditorRenderer.this.context);
                }
            }

            public String getDefaultText() {
                String def = element.read(DefaultValuePropertyEditorRenderer.this.getProperty()).getDefaultText();
                if (def != null && isSensitiveData) {
                    StringBuilder buf = new StringBuilder();
                    int i = 0;
                    int n = def.length();
                    while (i < n) {
                        buf.append("\u25cf");
                        ++i;
                    }
                    def = buf.toString();
                }
                return def;
            }
        };
        TextOverlayPainter.install(this.textField, textOverlayPainterController);
        if (isBrowseOnly || isReadOnly) {
            final Color bgcolor = new Color((Device)this.textField.getDisplay(), 245, 245, 245);
            this.textField.setBackground(bgcolor);
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    bgcolor.dispose();
                }
            });
        }
        ArrayList<ToolBar> relatedControls = new ArrayList<ToolBar>();
        this.textField.setData("related-controls", relatedControls);
        Listener actionHandlerListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphireActionHandler.PostExecuteEvent && !DefaultValuePropertyEditorRenderer.this.textField.isDisposed()) {
                    DefaultValuePropertyEditorRenderer.this.textField.setFocus();
                    DefaultValuePropertyEditorRenderer.this.textField.setSelection(0, DefaultValuePropertyEditorRenderer.this.textField.getText().length());
                }
            }
        };
        for (SapphireAction action : actions.getActions()) {
            if (action.getId().equals("Sapphire.Assist")) continue;
            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                handler.attach(actionHandlerListener);
            }
        }
        if (isActionsToolBarNeeded) {
            int alignment = isLongString ? 512 : 256;
            ToolBar toolbar = new ToolBar(textFieldParent, 0x800000 | alignment);
            toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
            toolBarActionsPresentation.setToolBar(toolbar);
            toolBarActionsPresentation.render();
            this.addControl((Control)toolbar);
            this.context.adapt((Control)toolbar);
            decorator.addEditorControl((Control)toolbar);
            relatedControls.add(toolbar);
        }
        if ((contentProposalService = (ContentProposalService)element.service((ModelProperty)property, ContentProposalService.class)) != null) {
            ContentProposalProvider contentProposalProvider = new ContentProposalProvider(contentProposalService, part);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.textField, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)contentProposalProvider, CONTENT_ASSIST_KEY_STROKE, null);
            contentProposalAdapter.setPropagateKeys(true);
            contentProposalAdapter.setLabelProvider((ILabelProvider)new ContentProposalLabelProvider());
            contentProposalAdapter.setProposalAcceptanceStyle(2);
        }
        if (isDeprecated) {
            Control deprecationMarker = this.createDeprecationMarker(textFieldParent);
            deprecationMarker.setLayoutData((Object)GridLayoutUtil.gd());
        }
        this.binding = new TextFieldBinding(this.getPart(), this.context, this.textField);
        this.textField.setData("binding", (Object)this.binding);
        this.addControl((Control)this.textField);
        List listenerClasses = part.getRenderingHint("listeners", Collections.emptyList());
        if (!listenerClasses.isEmpty()) {
            final ArrayList<ValuePropertyEditorListener> listeners = new ArrayList<ValuePropertyEditorListener>();
            for (Class cl : listenerClasses) {
                try {
                    ValuePropertyEditorListener listener = (ValuePropertyEditorListener)cl.newInstance();
                    listener.initialize(this.context, element, (ModelProperty)property);
                    listeners.add(listener);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
            if (!listeners.isEmpty()) {
                this.textField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        for (ValuePropertyEditorListener listener : listeners) {
                            try {
                                listener.handleValueChanged();
                            }
                            catch (Exception e) {
                                SapphireUiFrameworkPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }
        return this.textField;
    }

    protected boolean canScaleVertically() {
        return this.getProperty().hasAnnotation(LongString.class);
    }

    protected void handleFocusReceivedEvent() {
        this.textField.setFocus();
    }

    private static final class ContentProposalLabelProvider
    extends LabelProvider {
        private ContentProposalLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((ImageContentProposal)((Object)element)).getImage();
        }

        public String getText(Object element) {
            return ((ImageContentProposal)((Object)element)).getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContentProposalProvider
    implements IContentProposalProvider {
        private ContentProposalService contentProposalService;
        private ContentProposalService.Session session = null;
        private SapphirePart sapphirePart;

        public ContentProposalProvider(ContentProposalService contentProposalService, SapphirePart sapphirePart) {
            this.contentProposalService = contentProposalService;
            this.sapphirePart = sapphirePart;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (this.session == null) {
                this.session = this.contentProposalService.session();
            }
            String oldFilter = this.session.filter();
            int oldFilterLength = oldFilter.length();
            String newFilter = contents.substring(0, position);
            if (position < oldFilterLength || !oldFilter.equals(newFilter)) {
                this.session = this.contentProposalService.session();
                if (position > 0) {
                    this.session.advance(newFilter);
                }
            } else if (position > oldFilterLength) {
                this.session.advance(newFilter.substring(oldFilterLength));
            }
            List filterProposals = this.session.proposals();
            IContentProposal[] arrContentProposals = this.makeProposalArray(filterProposals);
            return arrContentProposals;
        }

        private IContentProposal[] makeProposalArray(List<org.eclipse.sapphire.services.ContentProposal> proposals) {
            if (proposals != null) {
                IContentProposal[] arrContentProposals = new IContentProposal[proposals.size()];
                int i = 0;
                while (i < proposals.size()) {
                    org.eclipse.sapphire.services.ContentProposal contentProposalInfo = proposals.get(i);
                    ImageContentProposal contentProposal = new ImageContentProposal(contentProposalInfo.content(), contentProposalInfo.label(), contentProposalInfo.description(), contentProposalInfo.content().length(), this.sapphirePart.getImageCache().getImage(contentProposalInfo.image()));
                    arrContentProposals[i] = contentProposal;
                    ++i;
                }
                return arrContentProposals;
            }
            return new IContentProposal[0];
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(PropertyEditorPart propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ValueProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, PropertyEditorPart part) {
            return new DefaultValuePropertyEditorRenderer(context, part);
        }
    }

    private static final class ImageContentProposal
    extends ContentProposal {
        private Image image;

        public ImageContentProposal(String content, String label, String description, int cursorPosition, Image image) {
            super(content, label, description, cursorPosition);
            this.image = image;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

