/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.AuxTextProvider;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public abstract class PropertyEditorRenderer {
    private static final String RELATED_CONTENT_WIDTH = "sapphire.related.content.width";
    protected final SapphireRenderingContext context;
    private final PropertyEditorPart part;
    protected PropertyEditorAssistDecorator decorator;
    private Label auxTextControl;
    private AuxTextProvider auxTextProvider;
    private final Set<Control> controls;
    protected AbstractBinding binding;
    private final SapphireActionGroup actions;
    private final SapphireActionPresentationManager actionPresentationManager;
    private final SapphireKeyboardActionPresentation actionPresentationKeyboard;
    private final List<Runnable> onDisposeOperations = new ArrayList<Runnable>();

    public PropertyEditorRenderer(SapphireRenderingContext context, PropertyEditorPart part) {
        this.context = context;
        this.part = part;
        this.controls = new HashSet<Control>();
        this.actions = part.getActions(part.getActionContext());
        this.actionPresentationManager = new SapphireActionPresentationManager(this.context, this.actions);
        this.actionPresentationManager.setLabel(NLS.bind((String)Resources.actionsContextLabel, (Object[])new Object[]{this.part.getProperty().getLabel(true, CapitalizationType.NO_CAPS, false)}));
        this.actionPresentationKeyboard = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
    }

    public SapphireRenderingContext getUiContext() {
        return this.context;
    }

    public PropertyEditorPart getPart() {
        return this.part;
    }

    public IModelElement getModelElement() {
        return this.part.getLocalModelElement();
    }

    public ModelProperty getProperty() {
        return this.part.getProperty();
    }

    public SapphireImageCache getImageCache() {
        return this.part.getImageCache();
    }

    public final SapphireActionGroup getActions() {
        return this.actions;
    }

    public final SapphireActionPresentationManager getActionPresentationManager() {
        return this.actionPresentationManager;
    }

    protected boolean canScaleVertically() {
        return false;
    }

    public final void create(Composite parent) {
        this.createContents(parent);
        String auxText = this.part.getRenderingHint("aux.text", null);
        Class auxTextProviderClass = this.part.getRenderingHint("aux.text.provider", null);
        if (auxTextProviderClass != null) {
            try {
                this.auxTextProvider = (AuxTextProvider)auxTextProviderClass.newInstance();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        if (auxText != null || this.auxTextProvider != null) {
            boolean spanBothColumns = this.part.getSpanBothColumns();
            if (!spanBothColumns) {
                Label placeholder = new Label(parent, 0);
                placeholder.setLayoutData((Object)GridLayoutUtil.gd());
                placeholder.setText("");
                this.context.adapt((Control)placeholder);
            }
            int hindent = this.part.getMarginLeft() + 9;
            this.auxTextControl = new Label(parent, 64);
            this.auxTextControl.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), spanBothColumns ? 2 : 1), hindent), 10));
            this.auxTextControl.setForeground(parent.getDisplay().getSystemColor(16));
            SwtUtil.reflowOnResize((Control)this.auxTextControl);
            this.addControl((Control)this.auxTextControl);
            if (auxText != null) {
                this.auxTextControl.setText(auxText);
            }
        }
        final PropertyEditorPart part = this.getPart();
        final IModelElement modelElement = this.getModelElement();
        ModelProperty property = this.getProperty();
        FilteredListener<PropertyEvent> propertyChangeListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                SwtUtil.runOnDisplayThread(new Runnable(){

                    public void run() {
                        PropertyEditorRenderer.this.handlePropertyChangedEvent();
                    }
                });
            }
        };
        modelElement.attach((Listener)propertyChangeListener, property.getName());
        this.handlePropertyChangedEvent();
        final Listener partListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.FocusReceivedEvent) {
                    PropertyEditorRenderer.this.handleFocusReceivedEvent();
                }
            }
        };
        part.attach(partListener);
        this.actionPresentationKeyboard.render();
        this.addOnDisposeOperation(new Runnable((Listener)propertyChangeListener, property){
            private final /* synthetic */ Listener val$propertyChangeListener;
            private final /* synthetic */ ModelProperty val$property;
            {
                this.val$propertyChangeListener = listener2;
                this.val$property = modelProperty;
            }

            public void run() {
                part.detach(partListener);
                modelElement.detach(this.val$propertyChangeListener, this.val$property.getName());
            }
        });
    }

    protected abstract void createContents(Composite var1);

    protected final Composite createMainComposite(Composite parent) {
        return this.createMainComposite(parent, new CreateMainCompositeDelegate(this.part));
    }

    protected final Composite createMainComposite(Composite parent, final CreateMainCompositeDelegate delegate) {
        boolean scaleVertically;
        boolean showLabel = delegate.getShowLabel();
        int leftMargin = delegate.getLeftMargin();
        boolean spanBothColumns = delegate.getSpanBothColumns();
        boolean singleLinePart = this.part.isSingleLinePart();
        List<SapphirePart> relatedContentParts = this.part.getRelatedContent();
        int count = relatedContentParts.size();
        if (showLabel) {
            final Label label = new Label(parent, 0);
            final Runnable updateLabelOp = new Runnable(){

                public void run() {
                    label.setText(String.valueOf(delegate.getLabel(CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
                }
            };
            final Listener listener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof SapphirePart.LabelChangedEvent) {
                        updateLabelOp.run();
                        PropertyEditorRenderer.this.context.layout();
                    }
                }
            };
            this.part.attach(listener);
            updateLabelOp.run();
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    PropertyEditorRenderer.this.getPart().detach(listener);
                }
            });
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), singleLinePart ? 0x1000000 : 128), spanBothColumns ? 2 : 1), leftMargin + 9));
            this.context.adapt((Control)label);
            this.addControl((Control)label);
        } else if (!spanBothColumns) {
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)GridLayoutUtil.gd());
            spacer.setText("");
            this.context.adapt((Control)spacer);
        }
        GridData gd = delegate.canScaleVertically() ? GridLayoutUtil.gdhhint((scaleVertically = this.part.getScaleVertically()) ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), this.part.getHeight(150)) : GridLayoutUtil.gdhfill();
        if (spanBothColumns) {
            gd = GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(gd, 2), leftMargin);
        }
        gd = GridLayoutUtil.gdwhint(gd, this.part.getWidth(200));
        final Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gd);
        this.context.adapt((Control)composite);
        if (count == 0) {
            return composite;
        }
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 0));
        boolean vcenter = this.part.isSingleLinePart() && relatedContentParts.size() == 1 && relatedContentParts.get(0).isSingleLinePart();
        Composite mainPropertyEditorOuterComposite = new Composite(composite, 0);
        mainPropertyEditorOuterComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 4, 0, 0));
        mainPropertyEditorOuterComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdhfill() : GridLayoutUtil.gdfill()));
        final Composite mainPropertyEditorComposite = new Composite(mainPropertyEditorOuterComposite, 0);
        mainPropertyEditorComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
        final Sash sash = new Sash(composite, 512);
        sash.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdvfill(), 1));
        final Composite relatedContentComposite = new Composite(composite, 0);
        relatedContentComposite.setLayoutData((Object)(vcenter ? GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 2) : GridLayoutUtil.gdfill()));
        relatedContentComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        relatedContentComposite.setData(RELATED_CONTENT_WIDTH, (Object)((double)this.part.getRelatedContentWidth() / 100.0));
        composite.addListener(11, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                PropertyEditorRenderer.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
            }
        });
        sash.addListener(13, new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                int width = composite.getClientArea().width - sash.getBounds().width;
                double ratio = (double)(width - event.x) / (double)width;
                if (ratio < 0.2) {
                    ratio = 0.2;
                }
                if (ratio > 0.8) {
                    ratio = 0.8;
                }
                relatedContentComposite.setData(PropertyEditorRenderer.RELATED_CONTENT_WIDTH, (Object)ratio);
                PropertyEditorRenderer.refreshSashFormLayout(composite, mainPropertyEditorComposite, relatedContentComposite, sash);
            }
        });
        this.context.adapt((Control)composite);
        for (SapphirePart relatedContentPart : relatedContentParts) {
            relatedContentPart.render(new SapphireRenderingContext(relatedContentPart, this.context, relatedContentComposite));
        }
        return mainPropertyEditorComposite;
    }

    private static final void refreshSashFormLayout(Composite rootComposite, Composite mainPropertyEditorComposite, Composite relatedContentComposite, Sash sash) {
        int mainPropertyEditorCompositeWidth;
        int rootCompositeWidth = rootComposite.getClientArea().width - sash.getBounds().width;
        double relatedContentCompositeWidthRatio = (Double)relatedContentComposite.getData(RELATED_CONTENT_WIDTH);
        int relatedContentCompositeWidth = (int)((double)rootCompositeWidth * relatedContentCompositeWidthRatio);
        ((GridData)mainPropertyEditorComposite.getLayoutData()).widthHint = mainPropertyEditorCompositeWidth = rootCompositeWidth - relatedContentCompositeWidth;
        ((GridData)relatedContentComposite.getLayoutData()).widthHint = relatedContentCompositeWidth;
        rootComposite.layout(true, true);
    }

    protected final PropertyEditorAssistDecorator createDecorator(Composite parent) {
        this.decorator = new PropertyEditorAssistDecorator(this.part, this.context, parent);
        return this.decorator;
    }

    protected final Control createDeprecationMarker(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Resources.deprecatedLabelText);
        this.context.adapt((Control)label);
        this.addControl((Control)label);
        label.setForeground(parent.getDisplay().getSystemColor(16));
        return label;
    }

    protected final void addControl(final Control control) {
        IModelElement element = this.getModelElement();
        ModelProperty property = this.getProperty();
        this.controls.add(control);
        control.setEnabled(element.enabled(property));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PropertyEditorRenderer.this.controls.remove(control);
                boolean timeToDispose = true;
                for (Control control2 : PropertyEditorRenderer.this.controls) {
                    if (control2.isDisposed()) continue;
                    timeToDispose = false;
                }
                if (timeToDispose) {
                    PropertyEditorRenderer.this.dispose();
                }
            }
        });
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addControl(child);
                ++n2;
            }
        }
        this.actionPresentationKeyboard.attach(control);
        this.context.setHelp(control, element, property);
    }

    protected void handlePropertyChangedEvent() {
        boolean enabled = this.getModelElement().enabled(this.getProperty());
        for (Control control : this.controls) {
            if (control.isDisposed()) continue;
            control.setEnabled(enabled);
        }
        if (this.auxTextProvider != null) {
            String auxText = this.auxTextProvider.getAuxText(this.getModelElement(), this.getProperty());
            this.auxTextControl.setText("(" + auxText + ")");
        }
    }

    protected void handleFocusReceivedEvent() {
    }

    protected final void addOnDisposeOperation(Runnable op) {
        this.onDisposeOperations.add(op);
    }

    private final void dispose() {
        for (Runnable op : this.onDisposeOperations) {
            try {
                op.run();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
        this.onDisposeOperations.clear();
    }

    protected class CreateMainCompositeDelegate {
        private final PropertyEditorPart part;

        public CreateMainCompositeDelegate(PropertyEditorPart part) {
            this.part = part;
        }

        public boolean getShowLabel() {
            return this.part.getShowLabel();
        }

        public String getLabel(CapitalizationType capitalizationType, boolean includeMnemonic) {
            return this.part.getLabel(capitalizationType, includeMnemonic);
        }

        public int getLeftMargin() {
            return this.part.getMarginLeft();
        }

        public boolean getSpanBothColumns() {
            return this.part.getSpanBothColumns();
        }

        public boolean canScaleVertically() {
            return PropertyEditorRenderer.this.canScaleVertically();
        }
    }

    private static final class Resources
    extends NLS {
        public static String actionsContextLabel;
        public static String deprecatedLabelText;

        static {
            Resources.initializeMessages((String)PropertyEditorRenderer.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

