/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import org.eclipse.help.IContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SapphireWizardPage
extends WizardPage {
    private final SapphireWizardPagePart part;
    private final Listener listener;

    public SapphireWizardPage(SapphireWizardPagePart part) {
        super((String)part.definition().getId().getContent());
        this.part = part;
        this.setTitle(this.part.getLabel());
        this.setDescription(this.part.getDescription());
        this.listener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireWizardPage.this.refreshImage();
                }
            }
        };
        this.part.attach(this.listener);
        this.refreshImage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdfill());
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        SapphireRenderingContext context = new SapphireRenderingContext(this.part, innerComposite){

            public void layout() {
                super.layout();
                IWizardContainer container = SapphireWizardPage.this.getContainer();
                if (container instanceof IWizardContainer2) {
                    ((IWizardContainer2)container).updateSize();
                }
            }
        };
        this.part.render(context);
        final Runnable messageUpdateOperation = new Runnable(){

            public void run() {
                Status st = SapphireWizardPage.this.part.getValidationState();
                if (st.severity() == Status.Severity.ERROR) {
                    SapphireWizardPage.this.setMessage(st.message(), 3);
                    SapphireWizardPage.this.setPageComplete(false);
                } else if (st.severity() == Status.Severity.WARNING) {
                    SapphireWizardPage.this.setMessage(st.message(), 2);
                    SapphireWizardPage.this.setPageComplete(true);
                } else {
                    SapphireWizardPage.this.setMessage(null);
                    SapphireWizardPage.this.setPageComplete(true);
                }
            }
        };
        messageUpdateOperation.run();
        Listener messageUpdateListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ValidationChangedEvent) {
                    messageUpdateOperation.run();
                }
            }
        };
        this.part.attach(messageUpdateListener);
        ISapphireDocumentation doc = (ISapphireDocumentation)this.part.definition().getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)composite, docdef);
            }
        }
        this.setControl((Control)composite);
    }

    public final void performHelp() {
        IContext documentationContext = this.part.getDocumentationContext();
        if (documentationContext != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(documentationContext);
        }
    }

    public void setVisible(boolean visible) {
        String initialFocusProperty;
        super.setVisible(visible);
        this.part.setVisible(visible);
        if (visible && (initialFocusProperty = (String)this.part.definition().getInitialFocus().getContent()) != null) {
            this.part.setFocus(initialFocusProperty);
        }
    }

    private final void refreshImage() {
        this.setImageDescriptor(SwtRendererUtil.toImageDescriptor(this.part.getImage()));
    }

    public void dispose() {
        super.dispose();
        this.part.detach(this.listener);
    }
}

