/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.services.ValueNormalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValue
implements Comparable<PossibleValue> {
    private final String value;
    private final String label;

    public static Factory factory(IModelElement element, ValueProperty property) {
        return new Factory(element, property);
    }

    private PossibleValue(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String value() {
        return this.value;
    }

    public String label() {
        return this.label;
    }

    @Override
    public int compareTo(PossibleValue entry) {
        if (this == entry) {
            return 0;
        }
        return this.label.compareTo(entry.label);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PossibleValue) {
            return this.value.equals(((PossibleValue)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /* synthetic */ PossibleValue(String string, String string2, PossibleValue possibleValue) {
        this(string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory {
        private final PossibleValuesService possibleValuesService;
        private final ValueNormalizationService valueNormalizationService;
        private final ValueLabelService valueLabelService;

        private Factory(IModelElement element, ValueProperty property) {
            this.possibleValuesService = (PossibleValuesService)element.service((ModelProperty)property, PossibleValuesService.class);
            this.valueNormalizationService = (ValueNormalizationService)element.service((ModelProperty)property, ValueNormalizationService.class);
            this.valueLabelService = (ValueLabelService)element.service((ModelProperty)property, ValueLabelService.class);
        }

        public List<PossibleValue> entries() {
            ArrayList<PossibleValue> entries = new ArrayList<PossibleValue>();
            for (String value : this.possibleValuesService.values()) {
                entries.add(this.entry(value));
            }
            Collections.sort(entries);
            return Collections.unmodifiableList(entries);
        }

        public PossibleValue entry(String value) {
            String normalized = this.valueNormalizationService.normalize(value);
            String label = this.valueLabelService.provide(normalized);
            return new PossibleValue(normalized, label, null);
        }
    }
}

