/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class HyperlinkTable {
    private static final Point IMAGE_OFFSET_PRIMARY_COLUMN;
    private static final Point IMAGE_OFFSET_SECONDARY_COLUMN;
    private static final Point TEXT_OFFSET_PRIMARY_COLUMN;
    private static final Point TEXT_OFFSET_SECONDARY_COLUMN;
    private boolean controlKeyActive;
    private final Table table;
    private TableItem mouseOverTableItem;
    private int mouseOverColumn;
    private Controller controller;

    static {
        String os = Platform.getOS();
        String osName = System.getProperties().getProperty("os.name");
        if (os.equals("win32")) {
            if (osName.equals("Windows XP")) {
                IMAGE_OFFSET_PRIMARY_COLUMN = new Point(0, 0);
                IMAGE_OFFSET_SECONDARY_COLUMN = new Point(0, 0);
                TEXT_OFFSET_PRIMARY_COLUMN = new Point(0, 2);
                TEXT_OFFSET_SECONDARY_COLUMN = new Point(-1, 2);
            } else {
                IMAGE_OFFSET_PRIMARY_COLUMN = new Point(0, 1);
                IMAGE_OFFSET_SECONDARY_COLUMN = new Point(0, 1);
                TEXT_OFFSET_PRIMARY_COLUMN = new Point(0, 2);
                TEXT_OFFSET_SECONDARY_COLUMN = new Point(0, 2);
            }
        } else {
            IMAGE_OFFSET_PRIMARY_COLUMN = new Point(1, 3);
            IMAGE_OFFSET_SECONDARY_COLUMN = new Point(1, 3);
            TEXT_OFFSET_PRIMARY_COLUMN = new Point(1, 3);
            TEXT_OFFSET_SECONDARY_COLUMN = new Point(1, 3);
        }
    }

    public HyperlinkTable(Table table, SapphireActionGroup actions) {
        this.table = table;
        this.controlKeyActive = false;
        this.mouseOverTableItem = null;
        this.mouseOverColumn = -1;
        final Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handleKeyEvent(event);
            }
        };
        final Display display = this.table.getDisplay();
        display.addFilter(1, keyListener);
        display.addFilter(2, keyListener);
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handleEraseItem(event);
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handlePaintItem(event);
            }
        });
        this.table.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handleMouseMove(event);
            }
        });
        this.table.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handleMouseExit(event);
            }
        });
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                HyperlinkTable.this.handleMouseDown(event);
            }
        });
        final SapphireActionHandler jumpActionHandler = new SapphireActionHandler(){

            protected Object run(SapphireRenderingContext context) {
                HyperlinkTable.this.handleJumpCommand();
                return null;
            }
        };
        final SapphireAction jumpAction = actions.getAction("Sapphire.Jump");
        jumpActionHandler.init(jumpAction, null);
        jumpAction.addHandler(jumpActionHandler);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                display.removeFilter(1, keyListener);
                display.removeFilter(2, keyListener);
                jumpAction.removeHandler(jumpActionHandler);
            }
        });
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Table getTable() {
        return this.table;
    }

    private void handleKeyEvent(Event event) {
        if (event.keyCode == 262144) {
            boolean bl = this.controlKeyActive = event.type == 1;
            if (!this.controlKeyActive) {
                this.update();
            }
        }
    }

    private void handleMouseMove(Event event) {
        this.mouseOverTableItem = null;
        this.mouseOverColumn = -1;
        int i = this.table.getTopIndex();
        int n = this.table.getItemCount();
        while (i < n) {
            TableItem item = this.table.getItem(i);
            int j = 0;
            int m = HyperlinkTable.getColumnCount(this.table);
            while (j < m) {
                Rectangle bounds = item.getTextBounds(j);
                if (bounds.contains(event.x, event.y)) {
                    GC gc = new GC((Drawable)this.table);
                    Point textExtent = gc.textExtent(item.getText(j));
                    gc.dispose();
                    bounds.width = textExtent.x;
                    bounds.height = textExtent.y;
                    if (!bounds.contains(event.x, event.y) || !this.controller.isHyperlinkEnabled(item, j)) break;
                    this.mouseOverTableItem = item;
                    this.mouseOverColumn = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.update();
    }

    private void handleMouseExit(Event event) {
        this.mouseOverTableItem = null;
        this.mouseOverColumn = -1;
        this.update();
    }

    private void handleMouseDown(Event event) {
        if (this.controlKeyActive && this.mouseOverTableItem != null) {
            TableItem item = this.mouseOverTableItem;
            this.table.setCursor(null);
            this.table.setSelection(item);
            this.handleJumpCommand(this.mouseOverTableItem, this.mouseOverColumn);
        }
    }

    private void handleJumpCommand() {
        TableItem[] items = this.table.getSelection();
        if (items.length == 1) {
            final TableItem item = items[0];
            final ArrayList<Integer> columnsWithHyperlinks = new ArrayList<Integer>();
            int i = 0;
            int n = HyperlinkTable.getColumnCount(this.table);
            while (i < n) {
                if (this.controller.isHyperlinkEnabled(item, i)) {
                    columnsWithHyperlinks.add(i);
                }
                ++i;
            }
            if (columnsWithHyperlinks.size() == 1) {
                this.handleJumpCommand(item, (Integer)columnsWithHyperlinks.get(0));
            } else if (!columnsWithHyperlinks.isEmpty()) {
                Dialog dialog = new Dialog(this.table.getShell()){
                    private int choice;
                    {
                        super($anonymous0);
                        this.choice = (Integer)list.get(0);
                    }

                    protected Control createDialogArea(Composite parent) {
                        this.getShell().setText(Resources.jumpDialogTitle);
                        Composite composite = (Composite)super.createDialogArea(parent);
                        Label prompt = new Label(composite, 64);
                        prompt.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 300));
                        prompt.setText(Resources.jumpDialogPrompt);
                        SelectionAdapter listener = new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                this.setChoice((Integer)event.widget.getData());
                            }
                        };
                        boolean first = true;
                        for (Integer col : columnsWithHyperlinks) {
                            Button button = new Button(composite, 80);
                            button.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gd(), 10));
                            button.setText(item.getText(col.intValue()));
                            button.setData((Object)col);
                            if (first) {
                                button.setSelection(true);
                                first = false;
                            }
                            button.addSelectionListener((SelectionListener)listener);
                        }
                        return composite;
                    }

                    protected void okPressed() {
                        super.okPressed();
                        HyperlinkTable.this.handleJumpCommand(item, this.choice);
                    }

                    private void setChoice(int choice) {
                        this.choice = choice;
                    }
                };
                dialog.open();
            }
        }
    }

    private void handleJumpCommand(final TableItem item, final int column) {
        Runnable op = new Runnable(){

            public void run() {
                HyperlinkTable.this.controller.handleHyperlinkEvent(item, column);
            }
        };
        BusyIndicator.showWhile((Display)this.table.getDisplay(), (Runnable)op);
    }

    private void handleEraseItem(Event event) {
        TableItem item = (TableItem)event.item;
        if (this.controlKeyActive && this.mouseOverTableItem == item) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    private void handlePaintItem(Event event) {
        TableItem item = (TableItem)event.item;
        if (this.controlKeyActive && this.mouseOverTableItem == item) {
            int i = 0;
            int n = HyperlinkTable.getColumnCount(this.table);
            while (i < n) {
                Point offset;
                Image image;
                Display display = this.table.getDisplay();
                String text = item.getText(i);
                Font font = item.getFont(i);
                TextStyle style = new TextStyle(font, null, null);
                if (this.mouseOverColumn == i) {
                    Color hyperlinkColor = JFaceColors.getActiveHyperlinkText((Display)display);
                    style.underline = true;
                    style.foreground = hyperlinkColor;
                    style.underlineColor = hyperlinkColor;
                }
                if ((image = item.getImage(i)) != null) {
                    Rectangle bounds = item.getBounds(i);
                    offset = i == 0 ? IMAGE_OFFSET_PRIMARY_COLUMN : IMAGE_OFFSET_SECONDARY_COLUMN;
                    event.gc.drawImage(image, bounds.x + offset.x, bounds.y + offset.y);
                }
                TextLayout layout = new TextLayout((Device)display);
                layout.setText(text);
                layout.setStyle(style, 0, text.length() - 1);
                offset = i == 0 ? TEXT_OFFSET_PRIMARY_COLUMN : TEXT_OFFSET_SECONDARY_COLUMN;
                Rectangle clientArea = item.getTextBounds(i);
                layout.setWidth(clientArea.width);
                layout.draw(event.gc, clientArea.x + offset.x, clientArea.y + offset.y);
                ++i;
            }
        }
    }

    private void update() {
        if (this.controlKeyActive && this.mouseOverTableItem != null) {
            this.table.setCursor(this.table.getDisplay().getSystemCursor(21));
        } else {
            this.table.setCursor(null);
        }
        this.table.redraw();
    }

    private static int getColumnCount(Table table) {
        int count = table.getColumnCount();
        return count == 0 ? 1 : count;
    }

    public static abstract class Controller {
        public boolean isHyperlinkEnabled(TableItem item, int column) {
            return true;
        }

        public abstract void handleHyperlinkEvent(TableItem var1, int var2);
    }

    private static final class Resources
    extends NLS {
        public static String jumpDialogTitle;
        public static String jumpDialogPrompt;

        static {
            Resources.initializeMessages((String)HyperlinkTable.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

