/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.ValidationService;

public final class CreateWorkspaceFileOpFolderValidator
extends ValidationService {
    public Status validate() {
        Value target = ((IModelElement)this.context(IModelElement.class)).read((ValueProperty)this.context(ValueProperty.class));
        Path path = (Path)target.getContent();
        if (path != null && path.segmentCount() > 0) {
            String projectName = path.segment(0);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
            if (resource == null || !(resource instanceof IProject) || !resource.isAccessible()) {
                String msg = NLS.bind((String)Resources.projectDoesNotExist, (Object[])new Object[]{projectName});
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String projectDoesNotExist;

        static {
            Resources.initializeMessages((String)CreateWorkspaceFileOpFolderValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

