/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.osgi.BundleLocator;
import org.eclipse.sapphire.util.ListFactory;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleBasedContext
extends Context {
    private final Bundle bundle;

    public static final Context adapt(String bundleId) {
        if (bundleId == null) {
            throw new IllegalArgumentException();
        }
        return BundleBasedContext.adapt(BundleLocator.find(bundleId));
    }

    public static final Context adapt(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        return new BundleBasedContext(bundle);
    }

    private BundleBasedContext(Bundle bundle) {
        this.bundle = bundle;
    }

    public <T> Class<T> findClass(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.bundle.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public URL findResource(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.bundle.getResource(name);
    }

    public List<URL> findResources(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ListFactory resourcesListFactory = ListFactory.start();
        try {
            Enumeration enumeration = this.bundle.getResources(name);
            while (enumeration.hasMoreElements()) {
                URL resource = (URL)enumeration.nextElement();
                if (resource == null) continue;
                resourcesListFactory.add((Object)resource);
            }
        }
        catch (IOException e) {
            LoggingService.log((Exception)e);
        }
        return resourcesListFactory.result();
    }
}

