/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.address;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.samples.address.internal.CityNamePossibleValuesService;
import org.eclipse.sapphire.samples.address.internal.StateCodePossibleValuesService;
import org.eclipse.sapphire.samples.address.internal.ZipCodePossibleValuesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GenerateImpl
public interface Address
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(Address.class);
    @Label(standard="street")
    @Required
    public static final ValueProperty PROP_STREET = new ValueProperty(TYPE, "Street");
    @Label(standard="city")
    @Required
    @Service(impl=CityNamePossibleValuesService.class)
    @DependsOn(value={"ZipCode", "State"})
    public static final ValueProperty PROP_CITY = new ValueProperty(TYPE, "City");
    @Label(standard="state")
    @Required
    @Service(impl=StateCodePossibleValuesService.class)
    @DependsOn(value={"ZipCode", "City"})
    public static final ValueProperty PROP_STATE = new ValueProperty(TYPE, "State");
    @Label(standard="ZIP code")
    @Required
    @Service(impl=ZipCodePossibleValuesService.class)
    @DependsOn(value={"State", "City"})
    public static final ValueProperty PROP_ZIP_CODE = new ValueProperty(TYPE, "ZipCode");

    public Value<String> getStreet();

    public void setStreet(String var1);

    public Value<String> getCity();

    public void setCity(String var1);

    public Value<String> getState();

    public void setState(String var1);

    public Value<String> getZipCode();

    public void setZipCode(String var1);
}

