/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.samples.calendar.integrated.CalendarEditor;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPagePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContactDetailsJumpHandler
extends SapphireJumpActionHandler {
    protected void initDependencies(List<String> dependencies) {
        super.initDependencies(dependencies);
        dependencies.add(IAttendee.PROP_IN_CONTACT_REPOSITORY.getName());
    }

    protected boolean computeEnablementState() {
        if (super.computeEnablementState()) {
            IAttendee attendee = (IAttendee)this.getModelElement();
            return (Boolean)attendee.isInContactRepository().getContent();
        }
        return false;
    }

    protected Object run(SapphireRenderingContext context) {
        CalendarEditor editor = (CalendarEditor)((Object)context.getPart().nearest(CalendarEditor.class));
        ContactDetailsJumpHandler.jump(editor, this.getModelElement());
        return null;
    }

    public static void jump(CalendarEditor editor, IModelElement modelElement) {
        IAttendee attendee = (IAttendee)modelElement;
        String name = attendee.getName().getText();
        if (name != null) {
            MasterDetailsEditorPagePart contactsFormPage;
            MasterDetailsContentOutline outline;
            MasterDetailsContentNode contactNode;
            Contact contact = null;
            for (Contact c : editor.getContactRepository().getContacts()) {
                if (!name.equals(c.getName().getText())) continue;
                contact = c;
                break;
            }
            if (contact != null && (contactNode = (outline = (contactsFormPage = (MasterDetailsEditorPagePart)editor.getEditorPagePart("Contacts")).outline()).getRoot().findNode((IModelElement)contact)) != null) {
                contactNode.select();
                editor.showPage((SapphireEditorPagePart)contactsFormPage);
            }
        }
    }
}

