/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.contacts.Contact;
import org.eclipse.sapphire.samples.contacts.ContactRepository;
import org.eclipse.sapphire.ui.PropertyEditorPart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;

public final class CreateContactActionHandler
extends SapphireActionHandler {
    private ValueProperty property;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.property = (ValueProperty)((PropertyEditorPart)action.getPart()).getProperty();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CreateContactActionHandler.this.refreshEnablementState();
            }
        };
        final IModelElement element = this.getModelElement();
        ((ContactRepository)element.nearest(ContactRepository.class)).attach((Listener)listener, "Contacts/Name");
        element.attach((Listener)listener, (ModelProperty)this.property);
        this.refreshEnablementState();
        this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)listener){
            private final /* synthetic */ Listener val$listener;
            {
                this.val$listener = listener;
            }

            protected void handleTypedEvent(DisposeEvent event) {
                ((ContactRepository)element.nearest(ContactRepository.class)).detach(this.val$listener, "Contacts/Name");
                element.detach(this.val$listener, (ModelProperty)CreateContactActionHandler.this.property);
            }
        });
    }

    private void refreshEnablementState() {
        boolean enabled;
        IModelElement element = this.getModelElement();
        String name = element.read(this.property).getText();
        ContactRepository cdb = (ContactRepository)element.nearest(ContactRepository.class);
        if (name == null) {
            enabled = false;
        } else {
            enabled = true;
            for (Contact contact : cdb.getContacts()) {
                if (!name.equals(contact.getName().getText())) continue;
                enabled = false;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    protected Object run(SapphireRenderingContext context) {
        IModelElement element = this.getModelElement();
        String name = element.read(this.property).getText();
        ContactRepository cdb = (ContactRepository)element.nearest(ContactRepository.class);
        Contact newContact = (Contact)cdb.getContacts().insert();
        newContact.setName(name);
        return null;
    }
}

